<?php
class IteratorObiektu implements Iterator {

   private $ob;
   private $ile;
   private $biezacyIndeks;

   function __construct($ob)
   {
     $this->ob = $ob;
     $this->ile = count($this->ob->dane);
   }
   function rewind()
   {
     $this->biezacyIndeks = 0;
   }
   function valid()
   {
     return $this->biezacyIndeks < $this->ile;
   }
   function key()
   {
     return $this->biezacyIndeks;
   }
   function current()
   {
     return $this->ob->dane[$this->biezacyIndeks];
   }
   function next()
   {
     $this->biezacyIndeks++;
   }
}

class Obiekt implements IteratorAggregate
{
  public $dane = array();

  function __construct($wejscie)
  {
    $this->dane = $wejscie;
  }

  function getIterator()
  {
    return new IteratorObiektu($this);
  }
}

$mojObiekt = new Obiekt(array(2, 4, 6, 8, 10));

$mojIterator = $mojObiekt->getIterator();
for($mojIterator->rewind(); $mojIterator->valid(); $mojIterator->next())
{
  $klucz = $mojIterator->key();
  $wartosc = $mojIterator->current();
  echo $klucz." => ".$wartosc."<br />";
}
?>

