<?

/*********************************************************************************
* Cz 1  wstpne przetwarzanie
*********************************************************************************/

  include('funkcje_dolacz.php');
  session_start();

  $przyciski=array();

  // doczenie do acucha jeeli procesy przed wysaniem nagwkw co 
  // wywietlaj
  $stan='';

  // logowanie i wylogowanie musi zosta wykonane na samym pocztku
  if($email&&$haslo)
  {
    $loguj=loguj($email, $haslo);

    if($loguj=='admin')
    {
      $stan .= "<p><b>".pobierz_nazwisko($email)."</b> pomylnie zalogowany jako"    
             ."<b> Administrator</b><br><br><br><br><br><br>";
      $uzyt_admin=$email;
      session_register("uzyt_admin");
    }
    else if($loguj=='zwykly')
    {
      $stan.= "<p><b>".pobierz_nazwisko($email)."</b> zalogowany pomylnie." 
              ."<br><br>";
      $zwykly_uzyt=$email;
      session_register("zwykly_uzyt");
    }
    else
    {
      $stan.="<p>Przepraszamy, ale zalogowanie przy pomocy podanego adresu i" 
              ." hasa niemoliwe.<br>";
    }
  }

  if($akcja=='wylogowanie')
  {
    session_destroy();
    unset($akcja);
    unset($zwykly_uzyt);
    unset($uzyt_admin);  // 50
  }
/*********************************************************************************
* Cz 2  konfiguracja i wywietlenie nagwkw
*********************************************************************************/

  // konfiguracja przyciskw, ktre znajd si na pasku narzdzi
  if(sprawdz_zwykly_uzyt())
  {
    // jeeli zwyky uytkownik
    $przyciski[0]='zmiana-hasla';
    $przyciski[1]='konfiguracja-konta';
    $przyciski[2]='pokaz-moje-listy';
    $przyciski[3]='pokaz-inne-listy';
    $przyciski[4]='wylogowanie';
  }
  else if(sprawdz_uzyt_admin())
  {
    // jeeli administrator
    $przyciski[0]='zmiana-hasla';
    $przyciski[1]='stworz-liste';
    $przyciski[2]='stworz-poczte';
    $przyciski[3]='zobacz-poczte';
    $przyciski[4]='wylogowanie';
    $przyciski[5]='pokaz-wszystkie-listy';
    $przyciski[6]='pokaz-moje-listy';
    $przyciski[7]='pokaz-inne-listy';
  }
  else
  {
    // jeeli w ogle nie zalogowany
    $przyciski[0]='nowe-konto';
    $przyciski[1]='pokaz-wszystkie-listy';
    $przyciski[4]='logowanie';
  }

  if($akcja)
  {
    // wywietlenie nagwka z nazw aplikacji i opisem strony lub akcji
    tworz_naglowek_html("MLP-Piramida  ".format_akcja($akcja));
  }
  else
  {
    // wywietlenie nagwka jedynie z nazw aplikacji
    tworz_naglowek_html("MLP-Piramida");
  }

  wyswietl_narzedzia($przyciski);

  //wywietlenie tekstu wygenerowanego przez funkcje wywoane przed nagwkiem
  echo $stan;

/*********************************************************************************
* Cz 3  wykonanie akcji
*********************************************************************************/

  // tylko te akcje mog by wykonane bez logowania
  switch($akcja)  // 100
  {
    case 'nowe-konto':
    {
      unset($zwykly_uzyt);
      unset($uzyt_admin);
      wyswietl_form_konta($zwykly_uzyt, $uzyt_admin);
      break;
    }
    case 'zachowaj-konto':
    {
      if(zachowaj_konto($zwykly_uzyt, $uzyt_admin, $HTTP_POST_VARS))
        $akcja='';
      if(!sprawdz_logowanie())
        wyswietl_form_log($akcja);
      break;
    }
    case 'logowanie':
    case '':
    {
      if(!sprawdz_logowanie())
        wyswietl_form_log($akcja);
      break;
    }
    case 'pokaz-wszystkie-listy':
    {
      wyswietl_elementy("Wszystkie listy", pobierz_wszystkie_listy(), 'informacja', 
                        'pokaz-archiwum', '');
      break;
    }
    case 'pokaz-archiwum':
    {
      wyswietl_elementy("Archiwum listy ".pobierz_nazwe_listy($id), 
                        pobierz_archiwum($id), 'podglad-html', 'podglad-tekstu', '');
      break;
    }
    case 'informacja':
    {
      wyswietl_informacje($id);
      break;
    }
  }

  // wszystkie pozostae akcje dostpne s jedynie uytkownikom zalogowanym
  if(sprawdz_logowanie())
  {
    switch($akcja)
    {
      case 'konfiguracja-konta':
      {
        wyswietl_form_konta($zwykly_uzyt, $uzyt_admin, pobierz_email(), 
                            pobierz_nazwisko(pobierz_email()), 
                            pobierz_typ_mime(pobierz_email()));
        break;
      }
      case 'pokaz-inne-listy':
      {
        wyswietl_elementy("Niesubskrybowane listy", 
                          pobierz_niesubskrybowane_listy(pobierz_email()), 
                          'informacja', 'pokaz-archiwum', 'subskrybuj');
        break;
      }
      case 'subskrybuj':
      {
        subskrybuj(pobierz_email(), $id);
        wyswietl_elementy("Subskrybowane listy", 
                          pobierz_subskrybowane_listy(pobierz_email()), 
                          'informacja', 'pokaz-archiwum', 'subskrybuj');
        break;
      }
      case 'nie-subskrybuj':
      {
        niesubskrybuj(pobierz_email(), $id);
        wyswietl_elementy("Subskrybowane listy", 
                          pobierz_subskrybowane_listy(pobierz_email()), 
                          'informacja', 'pokaz-archiwum', 'nie-subskrybuj');
        break;
      }
      case '':
      case 'pokaz-moje-listy':
      {
        wyswietl_elementy("Subskrybowane listy", 
                          pobierz_subskrybowane_listy(pobierz_email()), 
                          'informacja', 'pokaz-archiwum', 'nie-subskrybuj');
        break;
      }
      case 'zmiana-hasla':
      {
        wyswietl_form_hasla();
        break;
      }
      case 'zachowaj-zmiane-hasla':
      {
        if(zmien_haslo(pobierz_email(), $stare_haslo, $nowe_haslo, $nowe_haslo2))
        {
          echo"<p> OK: Haso zmienione.<br><br><br><br><br><br>";
        }
        else
        {
          echo "<p> Przepraszamy, ale haso nie mogo zosta zmienione.";
          wyswietl_form_hasla();
        }
        break;
      }
    }
  }
  // Ponisze akcje mog by wykonane jedynie przez administratora
  if(sprawdz_uzyt_admin())
  {
    switch($akcja)
    {
      case 'stworz-poczte':
      {
        wyswietl_form_poczty(pobierz_email());
        break;
      }
      case 'stworz-liste':
      {
        wyswietl_form_listy(pobierz_email());
        break;
      }
      case 'zachowaj-liste':
      {
        if(zachowaj_liste($uzyt_admin, $HTTP_POST_VARS))
        {
          echo "<p>Nowa lista dodana<br>";
          wyswietl_elementy("Wszystkie listy", pobierz_wszystkie_listy(), 
                            'informacja', 'pokaz-archiwum', '');
        }
        else
          echo "<p>Lista nie moga zosta zachowana, prosz sprbowa" 
               ."ponownie.<br><br><br><br><br>";
          break;
        }
        case 'wyslij':
        {
          wyslij($id, $uzyt_admin);
          break;
        }
        case 'zobacz-poczte':
        {
          wyswietl_elementy("Niewysana poczta", 
                            pobierz_niewyslana_poczte(pobierz_email()), 
                            'podglad-html', 'podglad-tekstu', 'wyslij');
          break;
        }
      }
    }
  

/*********************************************************************************
* Cz 4  wywietlenie stopki
*********************************************************************************/

  tworz_stopke_html();
?>
