<?
// ten skrypt jest gwn czci aplikacji wiea poczta
// pracuje oglnie jako komputer stanu i przedstawia uytkownikom
// wyniki wybranych przez nich dziaa

//*****************************************************************************
// Etap 1: wczesne przetwarzanie
// wykonanie wszystkich koniecznych dziaa przed wysaniem nagwka
// oraz wybranie szczegw, ktre maj zosta wywietlone w nagwkach strony
//*****************************************************************************

  include ('funkcje_dolacz.php');
  session_start();

  $przyciski=array();

  // doczenie do poniszego acucha wszystkich danych wywietlanych przed 
  // wysaniem nagwkw
  $stan='';

  // konieczno przetworzenia da logowania/wylogowania przed innymi 
  // dziaaniami
  if($nazwa_uz||$haslo)
  {
    if (loguj($nazwa_uz, $haslo))
    {
      $stan.="<p> zalogowano pomylnie.<br><br><br><br><br><br>";
      $uwierz_uzyt=$nazwa_uz;
      session_register("uwierz_uzyt");
      if(ilosc_kont($uwierz_uzyt)==1)
      {
        $konta=pobierz_liste_kont($uwierz_uzyt);
        $wybrane_konto=$konta[0];
        session_register("wybrane_konto");
      }
    }
    else
    {
      $stan.="<p>Przepraszamy, ale zalogowanie przy pomocy podanej nazwy 
              uytkownika i hasa niemoliwe. <br><br><br><br><br><br>";
    }
  }
  if($akcja=='wylogowanie')
  {
    session_destroy();
    unset($akcja);
    unset($uwierz_uzyt);
  }
//50
  // konieczno wybrania, usunicia lub przechowania konta przed narysowaniem 
  // nagwkw
  switch($akcja)
  {
    case 'usun-konto':
    {
      usun_konto($uwierz_uzyt, $konto);
      break;
    }
    case 'zachowaj-ustawienia':
    {
      przechowaj_ustawienia_konta($uwierz_uzyt, $HTTP_POST_VARS);
      break;
    }
    case 'wybierz-konto':
    {
      // jeeli wybrane prawidowe konto, przechowanie go jako zmiennej sesji
      if($konto&&istnieje_konto($uwierz_uzyt, $konto))

      {
        $wybrane_konto=$konto;
        session_register('wybrane_konto');
      }
    }
  }
  // ustawienie przyciskw paska narzdzi
  $przyciski[0]='przejrzyj-skrzynke';
  $przyciski[1]='nowa-wiadomosc';
  $przyciski[2]='konfiguracja-konta';
  // przycisk wylogowania tylko jeeli uytkownik zalogowany
  if(sprawdz_uwierz_uzyt())
  {
    $przyciski[4]='wylogowanie';
  }

//*****************************************************************************
// Etap 2: nagwki
// wysanie nagwkw HTML i paska menu zalenie od obecnej akcji
//*****************************************************************************

  if($akcja)
  {
    // wywietlenie nagwka z nazw aplikacji i opisem strony lub akcji
  tworz_naglowek_html($uwierz_uzyt, "wiea poczta  ".format_akcja($akcja), $wybrane_konto);
  }
  else
  {
    // wywietlenie nagwka jedynie z nazw aplikacji
        tworz_naglowek_html($uwierz_uzyt, "wiea poczta", $wybrane_konto);
  }
// 100
  wyswietl_narzedzia($przyciski);

//*****************************************************************************
// Etap 3: gwna zawarto
//zalenie od akcji, wywietlenie odpowiedniej gwnej zawartoci
//*****************************************************************************

  // wywietlenie caego tekstu generowanego przez funkcje wywoane przed 
  // nagwkiem
  echo $stan;

  if(!sprawdz_uwierz_uzyt())
  {
    echo "<p>Naley by zalogowanym";
    if($akcja&&$akcja!='wylogowanie')
      echo " aby oglda ".format_akcja($akcja);
    echo "<br><br>";
    wyswietl_form_log($akcja);
  }
  else
  {
    switch($akcja)
    {
      // jeeli konfiguracja nowego konta lub wanie nastpio dodanie lub 
      // usunicie konta, strona konfiguracji konta
      case 'zachowaj-ustawienia':
      case 'konfiguracja-konta':
      case 'usuniecie-konta':
      {
        wyswietl_konf_konta($uwierz_uzyt);
        break;
      }
      case 'wyslij-wiadomosc':
      {
        if(wyslij_wiadomosc($do, $dw, $temat, $wiadomosc))
          echo "<p>Wiadomo wysana.<br><br><br><br><br><br>";
        else
          echo "<p>Wysanie wiadomoci niemoliwe.<br><br><br><br><br><br>";
        break;
      }
      case 'usun':
      {
        usun_wiadomosc($uwierz_uzyt, $wybrane_konto, $id_wiadomosci);
        // brak zakoczenia 'break'  kontynuacja do nastpnego przypadku
      }
      case 'wybierz-konto':
      case 'przejrzyj-skrzynke':
      {
        // jeeli skrzynka wanie wybrana lub wybrano przejrzyj-skrzynke 
        // wywietlenie skrzynki   150
        wyswietl_liste($uwierz_uzyt, $wybrane_konto);
        break;
      }
      case 'pokaz-naglowki':
      case 'ukryj-naglowki':
      case 'zobacz-wiadomosc':
      {
        // jeeli wanie pobrana wiadomo z listy, lub przy ogldaniu wiadomoci 
        // wybrano pokazanie lub ukrycie wiadomoci, pobranie wiadomoci
        $pelne_naglowki=($akcja=='pokaz-naglowki');
        wyswietl_wiadomosc($uwierz_uzyt, $wybrane_konto, $id_wiadomosci, 
                           $pelne_naglowki);
        break;
      }
      case 'odpowiedz-wszystkim':
      {
        // ustawienie dw jako starej linii dw
        if(!$imap)
          $imap=otworz_skrzynke($uwierz_uzyt, $wybrane_konto);
        if($imap)
        {
          $naglowek=imap_header($imap, $id_wiadomosci);
          if($naglowek->reply_toaddress)
            $do=$naglowek-> reply_toaddress;
          else
            $do=$naglowek->fromaddress;
          $dw=$naglowek->ccaddress;
          $temat='Odp: '.$naglowek->subject;
          $glowny=dodaj_znaki(stripslashes(imap_body($imap, $id_wiadomosci)));
          imap_close($imap);

          wyswietl_nowa_wiad_form($uwierz_uzyt, $do, $dw, $temat, $glowny);
        }
        break;
      }
      case 'odpowiedz':
      {
        // ustawienie adresu na reply-to lub z obecnej wiadomoci
        if(!$imap)
          $imap=otworz_skrzynke($uwierz_uzyt, $wybrane_konto);
        if($imap)
        {
          $naglowek=imap_header($imap, $id_wiadomosci);
          if($naglowek->reply_toaddress)
            $do=$naglowek-> reply_toaddress;
          else
            $do=$naglowek->fromaddress;
          $temat='Odp: '.$naglowek->subject;
          $glowny=dodaj_znaki(stripslashes(imap_body($imap, $id_wiadomosci)));
          imap_close($imap); // 200

          wyswietl_nowa_wiad_form($uwierz_uzyt, $do, $dw, $temat, $glowny);
        }
        break;
      }
      case 'przekazanie':
      {
        // ustawienie wiadomoci jako tekstu obecnej wiadomoci
        if(!$imap)
          $imap=otworz_skrzynke($uwierz_uzyt, $wybrane_konto);
        if($imap)
        {
          $naglowek=imap_header($imap, $id_wiadomosci);
          $glowny=dodaj_znaki(stripslashes(imap_body($imap, $id_wiadomosci)));
          $temat='Fw: '.$naglowek->subject;
          imap_close($imap);

          wyswietl_nowa_wiad_form($uwierz_uzyt, $do, $dw, $temat, $glowny);
        }
        break;
      }
      case 'nowa-wiadomosc':
      {
        wyswietl_nowa_wiad_form($uwierz_uzyt, $do, $dw, $temat, $glowny);
        break;
      }
    }
  }
//*****************************************************************************
// Etap 4: stopka
  tworz_stopke_html();
//*****************************************************************************
?>
