<?
require_once ("funkcje_ksiazka_kz.php");
function tworz_naglowek_html($tytul = '')
{
  // wywietlenie nagwka HTML
 
  // zadeklarowanie zmiennych sesji zastosowanych w funkcji
  global $calkowita_wartosc;
  global $produkty;
  if(!$produkty) $produkty = "0";
  if(!$calkowita_wartosc) $calkowita_wartosc = "0.00";
?>
  <html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=windows-1250">
    <title><?=$tytul?></title>
    <style>
      h2 { font-family: Arial, Helvetica, sans-serif; font-size: 22px; color = red; margin = 6px }
      body { font-family: Arial, Helvetica, sans-serif; font-size: 13px; background-color: white }
      li, td { font-family: Arial, Helvetica, sans-serif; font-size: 13px }
      hr { color: #FF0000; width=70%; text-align=center}
      a { color: #000000 }
    </style>
  </head>
  <body>
  <table width=100% border=0 cellspacing = 0 bgcolor=#cccccc>
  <tr>
  <td rowspan = 2>
  <a href = "indeks.php"><img src="obrazki/ksiazkorama.gif" alt="Ksikorama" border=0
       align=left valign=bottom height = 55 width = 325></a>
  </td>
  <td align = right valign = bottom>
  <? if(session_is_registered("uzyt_admin"))
       echo "&nbsp;";
     else
       echo "Ilo produktw = $produkty"; 
  ?>
  </td>
  <td align = right rowspan = 2 width = 135>
  <? if(session_is_registered("uzyt_admin"))
       wyswietl_przycisk("wylog.php", "wylogowanie", "Wylogowanie");
     else
       wyswietl_przycisk("pokaz_kosz.php", "zobacz-kosz", "Widok koszyka na zakupy");
  ?>
  </tr>
  <tr>
  <td align = right valign = top>
  <? if(session_is_registered("uzyt_admin"))
       echo "&nbsp;";
     else
       echo "Warto = PLN ".number_format($calkowita_wartosc,2); 
  ?>
  </td>
  </tr>
  </table>
<?
  if($tytul)
    tworz_tytul_html($tytul);
}

function tworz_stopke_html()
{
  // wywietlenie stopki HTML
?>
  </body>
  </html>
<?
}

function tworz_tytul_html($naglowek)
{
  // print heading
?>
  <h2><?=$naglowek?></h2>
<?
}

function tworz_html_url($url, $nazwa)
{
  // wywietlenie URL-a jako cza i nowa linia
?>
  <a href="<?=$url?>"><?=$nazwa?></a><br>
<?
}

function wyswietl_kategorie($tablica_kat)
{
  if(!is_array($tablica_kat))
  {
    echo "Brak dostpnych kategorii<br>";
    return;
  }
  echo "<ul>";
  foreach($tablica_kat as $rzad)
  {
    $url="pokaz_kat.php?idkat=".($rzad["idkat"]);
    $tytul=$rzad["nazwakat"];
    echo "<li>";
    tworz_html_url($url, $tytul); 
  }
  echo "</ul>";
  echo "<hr>";
}


function wyswietl_ksiazki($tablica_ksiazek)
{
  //wywietlenie wszystkich ksiek z przekazanej tablicy
  if (!is_array($tablica_ksiazek))
  {
     echo "<br>Brak aktualnie dostpnych ksiek w tej kategorii<br>";
  }
  else
  {
    //stworzenie tabeli
    echo "<table width = \"100%\" border = 0>";
    
    //stworzenie wiersza tabeli dla kadej ksiki
    foreach ($tablica_ksiazek as $rzad)
    {
      $url = "pokaz_ksiazke.php?isbn=".($rzad["isbn"]);
      echo "<tr><td>";
      if (@file_exists("obrazki/".$rzad["isbn"].".jpg"))
      {
        $tytul = "<img src=\"obrazki/".($rzad["isbn"]).".jpg\" border=0>";
        tworz_html_url($url, $tytul);
      }
      else
      {
        echo "&nbsp;";
      }
      echo "</td><td>";
      $tytul =  $rzad["tytul"]." autor ".$rzad["autor"];
      tworz_html_url($url, $tytul);
      echo "</td></tr>";
    }
    echo "</table>";
  }
  echo "<hr>";
}

function wyswietl_dane_ksiazki($ksiazka)
{
  // wywietlenie wszystkich danych konkretnej ksiki
  if (is_array($ksiazka))
  {
    echo "<table><tr>"; 
    //wywietlenie obrazka jeeli istnieje
    if (@file_exists("obrazki/".($ksiazka["isbn"]).".jpg"))
    {
      $wielkosc = GetImageSize("obrazki/".$ksiazka["isbn"].".jpg");
      if($wielkosc[0]>0 && $wielkosc[1]>0)
        echo "<td><img src=\"obrazki/".$ksiazka["isbn"].".jpg\" border=0 ".$wielkosc[3]."></td>";
    }
    echo "<td><ul>";
    echo "<li><b>Autor:</b> ";
    echo $ksiazka["autor"];
    echo "<li><b>ISBN:</b> ";
    echo $ksiazka["isbn"];
    echo "<li><b>Cena:</b> ";
    echo number_format($ksiazka["cena"], 2);
    echo "<li><b>Opis:</b> ";
    echo $ksiazka["opis"];
    echo "</ul></td></tr></table>"; 
  }
  else
    echo "Dane tej ksiki nie mog zosta wywietlone w tym momencie.";
  echo "<hr>";
}

function wyswietl_form_kasy()
{
  // wywietlenie formularza pobierajcego adres
?>
  <br>
  <table border = 0 width = 100% cellspacing = 0>
  <form action = zakup.php method = post>
  <tr><th colspan = 2 bgcolor="#cccccc">Dane klienta:</th></tr>
  <tr>
    <td>Nazwisko</td>
    <td><input type = text name = nazwisko value = "" maxlength = 40 size = 40></td>
  </tr>
  <tr>
    <td>Adres</td>
    <td><input type = text name = adres value = "" maxlength = 40 size = 40></td>
  </tr>
  <tr>
    <td>Miasto</td>
    <td><input type = text name = miasto value = "" maxlength = 20 size = 40></td>
  </tr>
  <tr>
    <td>Wojewdztwo</td>
    <td><input type = text name = wojew value = "" maxlength = 20 size = 40></td>
  </tr>
  <tr>
    <td>Kod pocztowy</td>
    <td><input type = text name = kod_poczt value = "" maxlength = 10 size = 40></td>
  </tr>
  <tr> 
    <td>Kraj</td>
    <td><input type = text name = kraj value = "" maxlength = 20 size = 40></td>
  </tr>
  <tr><th colspan = 2 bgcolor="#cccccc">Adres dostawy (prosz zostawi puste jeeli taki sam jak powyszy)</th></tr>
  <tr>
    <td>Nazwisko</td>
    <td><input type = text name = dos_nazwisko value = "" maxlength = 40 size = 40></td>
  </tr>
  <tr>
    <td>Adres</td>
    <td><input type = text name = dos_adres value = "" maxlength = 40 size = 40></td>
  </tr>
  <tr>
    <td>Miasto</td>
    <td><input type = text name = dos_miasto value = "" maxlength = 20 size = 40></td>
  </tr>
  <tr>
    <td>Wojewdztwo</td>
    <td><input type = text name = dos_wojew value = "" maxlength = 20 size = 40></td>
  </tr>
  <tr>
    <td>Kod pocztowy</td>
    <td><input type = text name = dos_kod_poczt value = "" maxlength = 10 size = 40></td>
  </tr>
  <tr>
    <td>Kraj</td>
    <td><input type = text name = dos_kraj value = "" maxlength = 20 size = 40></td>
  </tr>
  <tr>
    <td colspan = 2 align = center>
      <b>Prosz nacisn przycisk "Zakup" w celu dokonania zakupu,
         Lub "Kontynuacja zakupw" w celu zmiany zamwienia</b> 
     <? wyswietl_form_przycisk("zakup", "Zakupienie tych produktw"); ?>
    </td>
  </tr>
  </form>
  </table><hr>
<?
}

function wyswietl_dostawe($dostawa)
{
  // wywietlenie kosztw dostawy i cakowitej wartoci
  global $calkowita_wartosc;
?>
  <table border = 0 width = 100% cellspacing = 0>
  <tr><td align = left>Dostawa</td>
      <td align = right> <?=number_format($dostawa, 2); ?></td></tr>
  <tr><th bgcolor="#cccccc" align = left>Warto razem z dostaw</th>
      <th bgcolor="#cccccc" align = right>PLN <?=number_format($dostawa+$calkowita_wartosc, 2); ?></th>
  </tr>
  </table><br>
<?
}

function wyswietl_form_karty($nazwisko)
{
  // wywietlenie formularza karty
?>
  <table border = 0 width = 100% cellspacing = 0>
  <form action = przetworz.php method = post>
  <tr><th colspan = 2 bgcolor="#cccccc">Szczegy karty kredytowej</th></tr>
  <tr>
    <td>Typ</td>
    <td><select name = typ_karty><option>VISA<option>MasterCard<option>American Express</select></td>
  </tr>
  <tr>
    <td>Numer</td>
    <td><input type = text name = numer_karty value = "" maxlength = 16 size = 40></td>
  </tr>
  <tr>
    <td>kod AMEX (jeeli wymagany)</td>
    <td><input type = text name = kod_amex value = "" maxlength = 4 size = 4></td>
  </tr>
  <tr>
    <td>Data wanoci</td>
    <td>Miesic <select name = miesiac_karty><option>01<option>02<option>03<option>04<option>05<option>06<option>07<option>08<option>09<option>10<option>11<option>12</select>
    Rok <select name = rok_karty><option>00<option>01<option>02<option>03<option>04<option>05<option>06<option>07<option>08<option>09<option>10</select></td>
  </tr>
  <tr>
    <td>Nazwisko na karcie</td>
    <td><input type = text name = nazwa_karty value = "<?=$nazwisko; ?>" maxlength = 40 size = 40></td>
  </tr>
  <tr>
    <td colspan = 2 align = center>
      <b>Prosz nacisn przycisk "Kupuj" w celu dokonania zakupu
         lub "Kontynuuj zakupy" w celu zmiany zamwienia</b>
     <? wyswietl_form_przycisk("zakup", "Zakup tych produktw"); ?>
    </td>
  </tr>
  </table>
<?
}



function wyswietl_koszyk($koszyk, $zmiana=true, $obrazki=1)
{
  // wywietlenie zawartoci koszyka
  // opcjonalnie pozwala na zmiany (true lub false)
  // opcjonalnie docza obrazki(1  tak, 0  nie)

  global $produkty;
  global $calkowita_wartosc;

  echo "<table border=0 width=100% cellspacing=0>
        <form action=pokaz_kosz.php method=post>
        <tr><th colspan=".(1+$obrazki)." bgcolor=\"#cccccc\">Produkt</th>
        <th bgcolor=\"#cccccc\">Cena</th><th bgcolor=\"#cccccc\">Ilo</th>
        <th bgcolor=\"#cccccc\">Warto</th></tr>";

  // wywietlanie kadego produktu jako wiersza tabeli
  foreach($koszyk as $isbn=>$ilosc)
  {
    $ksiazka=pobierz_dane_ksiazki($isbn);
    echo "<tr>";
    if($obrazki==true)
    {
      echo "<td align=left>";
      if(file_exists("obrazki/$isbn.jpg"))
      {
        $wielkosc=GetImageSize("obrazki/".$isbn.".jpg");
        if($wielkosc[0]>0 && $wielkosc[1]>0)
        {
          echo "<img src=obrazki/".$isbn.".jpg border=0 ";
          echo "width=". $wielkosc[0]/3 ." height=". $wielkosc[0]/3 . ">";
        }
      }
      else
        echo "&nbsp;";
      echo "</td>";
    }
    echo "<td align=left>";
    echo "<a href=\"pokaz_ksiazke.php?isbn=".$isbn."\">"
                  .$ksiazka["tytul"]."</a> autor ".$ksiazka["autor"];
    echo "</td><td align=center>PLN".number_format($ksiazka["cena"], 2);
    echo "</td><td align=center>";

    // jeeli zmiany s dozwolone, iloci znajduj si w polach tekstowych
    if($zmiana==true)
      echo "<input type=text name=\"$isbn\" value=$ilosc size=3>";
    else
      echo $ilosc;
    echo "</td><td align=center>PLN ".number_format($ksiazka["cena"]*$ilosc, 2)
         ."</td></tr>\n";
  }

  // wywietl wiersz sumy
  echo "<tr>
          <th colspan=".(2+$obrazki)." bgcolor=\"#cccccc\">&nbsp;</td>
          <th align=center bgcolor=\"#cccccc\">
              $produkty
          </th>
          <th align=center bgcolor=\"#cccccc\">
              PLN".number_format($calkowita_wartosc, 2).
          "</th>
       </tr>";

  // wywietl przycisk zapisujcy zmiany
  if($zmiana==true)
  {
    echo "<tr>
            <td colspan=".(2+$obrazki).">&nbsp;</td>
            <td align=center>
              <input type=hidden name=zapisz value=true>
              <input type=image src=\"obrazki/zapisz-zmiany.gif\" 
                      border=0 height = 50 width=130 alt=\"Zapisz zmiany\">
            </td>
            <td>&nbsp;</td>
         </tr>";
  }
  echo "</form></table>";
}


function wyswietl_form_log()
{
  // wywietlenie formularza logowania
?>
  <form method=post action="admin.php">
  <table bgcolor=#cccccc>
   <tr>
     <td>Nazwa uytkownika:</td>
     <td><input type=text name=nazwa_uz></td></tr>
   <tr>
     <td>Haso:</td>
     <td><input type=password name=haslo></td></tr>
   <tr>
     <td colspan=2 align=center>
     <input type=submit value="Logowanie"></td></tr>
   <tr>
 </table></form>
<?
}

function wyswietl_menu_admin()
{
?>
<br>
<a href="indeks.php">Gwna strona</a><br>
<a href="dodaj_kat_form.php">Dodanie nowej kategorii</a><br>
<a href="dodaj_ksiazke_form.php">Dodanie nowej ksiki</a><br>
<a href="zmiana_hasla_form.php">Zmiana hasa administratora</a><br>
<?

}

function wyswietl_przycisk($cel, $obrazek, $alt)
{
  echo "<center><a href=\"$cel\"><img src=\"obrazki/$obrazek".".gif\" 
           alt=\"$alt\" border=0 height = 50 width = 135></a></center>";
}

function wyswietl_form_przycisk($obrazek, $alt)
{
  echo "<center><input type = image src=\"obrazki/$obrazek".".gif\" 
           alt=\"$alt\" border=0 height = 50 width = 135></center>";
}

