drop database if exists zawartosc;

create database zawartosc;

use zawartosc;

drop table if exists autorzy;

create table autorzy (
  nazwa_uz       varchar(16) primary key,
  haslo          varchar(16) not null,
  pelne_nazwisko text
);

drop table if exists artykuly;

create table artykuly (
id               int primary key auto_increment,
autor            varchar(16) not null,          # foreign key autorzy.nazwa_uz
strona           varchar(16) not null,          # foreign key strony.kod
naglowek         text,
tekst_artykulu   text,
obrazek          text,
utworzony        int,
zmodyfikowany    int,
opublikowany     int
);

drop table if exists strony;

create table strony (
kod              varchar(16) primary key,
opis             text
);

drop table if exists uprawnienia_autora;

create table uprawnienia_autora (
autor            varchar(16) not null,          # foreign key autorzy.nazwa_uz
strona           varchar(16) not null           # foreign key strony.kod
);

drop table if exists slowa_kluczowe;

create table slowa_kluczowe (
artykul          int not null,                  # foreign key artykuly.id
slowo_klucz      varchar(32) not null,
waznosc          int not null
);

grant select, insert, update, delete
on zawartosc.*
to zawartosc@localhost identified by 'haslo';



insert into autorzy (nazwa_uz, haslo, pelne_nazwisko)
             values ('piotr', password('haslo'), 'Piotr Kowalski');

insert into autorzy (nazwa_uz, haslo, pelne_nazwisko)
             values ('pawel', password('haslo'), 'Pawe Nowak');


insert into strony (kod, opis)
           values ('wiadomosci', 'Najnowsze wiadomoci z caego wiata');

insert into strony (kod, opis)
           values ('sport', 'Informacje sportowe - zwycizcy i przegrani');

insert into strony (kod, opis)
           values ('pogoda', 'Prognoza pogody z dokadoci co do minuty');


insert into uprawnienia_autora (autor, strona) values ('piotr', 'wiadomosci');
insert into uprawnienia_autora (autor, strona) values ('piotr', 'sport');

insert into uprawnienia_autora (autor, strona) values ('pawel', 'wiadomosci');
insert into uprawnienia_autora (autor, strona) values ('pawel', 'pogoda');


insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (1, 'piotr', 'wiadomosci', 'Mczyzna rodzi', 976573221, 976580154, 976570230,
   'Dzisiaj w szpitalu w Los Angeles mczyzna urodzi dziecko.  Chopczyk way nieco ponad cztery kilo i czuje si dobrze.  Rodzice s szczliwi z powodu urodzenia si ich pierwszego syna, i maj nadziej na posiadanie duej rodziny.  <br><br>Ojciec Ted, 34, urodzi dziecko po przeniesieniu podu do jego ciaa we wczesnym stadium ciy.  Naukowcy twierdz, e nowa metoda, znana jako ojcierzystwo, pozwala na zredukowania ryzyka okooporodowego', 'obrazki/1.jpg');

insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (2, 'pawel', 'wiadomosci', 'Ogie!', 976562355, 976572203, 976570230,
    'Wiadomo z ostatniej chwili:  Gdzie w wojewdztwie podlaskim pali si stodoa.  Nasze rda twierdz, e prawdopodobnie spali si doszcztnie i odbudowanie jej nie bdzie opacalne.<br><br>Naoczny wiadek stwierdzi: "Wida sporo dymu"', 'obrazki/2.jpg');

insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (3, 'piotr', 'wiadomosci', 'Raport z otwarcia SSWO', 976542355, 976542503, 976555650,
    'Wczorajszy dzie przeszed do historii jako dzie pojawienia si w Internecie najlepszego serwisu informacyjnego.  W Warszawie odbyo si wspaniae przyjcie.<br><br>Brao w nim udzia wiele pragncych zachowa anonimowo gwiazd pierwszej wielkoci.', 'obrazki/3.jpg');

insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (4, 'piotr', 'sport', 'Zapowied Mistrzostw wiata w rozwizywaniu krzywek', 976531355, 976532503, 976533320,
    'Za trzy dni rozpoczn si prestiowe doroczne Mistrzostwa wiata w rozwizywaniu krzywek, po raz pierwszy odbywajce si na ywo w Internecie.  Nowe medium umoliwi udzia w mistrzostwach wikszej iloci uczestnikw, ktrzy mog jednoczenie pozosta w domu, Lub w jednym ze 126 centrw regionalnych.<br><br>Zeszoroczna zwyciczyni nie jest zadowolna z nowej formy mistrzostw.  Powiedziaa: Krzywki powinny by rozwizywane na papierze, nie online".', 'obrazki/4.jpg');

insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (5, 'pawel', 'sport', 'Koszykwka szkodliwa dla zdrowia', 976542355, 976542503, 976555650,
    'Naukowcy twierdz, e koszykwka moe by szkodliwa dla zdrowia.  Badania dowiody, e zarwno gra, jak i kibicowanie moe odnosi zy skutek dla zdrowia.  Informacje te weryfikowane s aktualnie przez nasz zesp ekspertw, ktrych wyniki prac przedstawimy tak szybko jak bdzie to moliwe.<br><br>Rzecznik ligi NBA powiedzia: "To jest kompletna bzdura".', 'obrazki/5.jpg');

insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (6, 'pawel', 'pogoda', 'Nadchodz burze', 976542355, 976542503,
976555650, 'Nie pada, ale kropi.  Kiedy deszcze nadejd w listopadzie, bdzie burza<br><br> Meteorolodzy przewiduj deszcz, byskawice, grzmoty oraz wszystkie tradycyjne nieprzyjemnoci.  Jak na razie nie ma wiadomoci na temat huraganw, ale nie wyklucza si tej moliwoci!', 'obrazki/6.jpg');

insert into artykuly 
    (id, autor, strona, naglowek, utworzony, zmodyfikowany, opublikowany,
     tekst_artykulu, obrazek)
values (7, 'pawel', 'pogoda', 'wieci soce, pogoda jest pikna', 976451129, 976458734, 976458754,
    'Prognoza pogody na najbliszy weekend jest dobra, z dugimi okresami soca we wszystkich czciach kraju.  Temperatura osignie 30 stopni, a deszcz pojawi sie dopiero w listopadzie', 'obrazki/7.jpg');

