<?
// sprawdzenie, czy dostpne s odpowiednie dane zmiennych
// zmienne to tekst_przycisku oraz kolor
if(empty($tekst_przycisku) || empty($kolor))
{
  echo "Stworzenie obrazka niemoliwe - formularz wypeniony niepoprawnie";
  exit;
}

// utworzenie obrazka o prawidowym tle oraz sprawdzenie wielkoci
$ob=imagecreatefrompng("$kolor-przycisk.png");

$szerokosc_obrazka=ImageSX($ob);
$wysokosc_obrazka=ImageSY($ob);

// przyciski musz mie 18-pikselowy margines od krawdzi
$szerokosc_obrazka_bez_marginesow=$szerokosc_obrazka - (2 * 18); 
$wysokosc_obrazka_bez_marginesow=$wysokosc_obrazka - (2 * 18);

// Obliczenie pasujcego rozmiaru czcionki i odpowiednie go zmniejszenie
// Rozpoczcie od najwikszego rozmiaru, ktry intuicyjnie pasowaby do przyciskw
$rozmiar_czcionki=33;

do
{
  $rozmiar_czcionki--;

  //obliczenie rozmiaru tekstu przy tym rozmiarze czcionki
  $bbox=imagettfbbox($rozmiar_czcionki, 0, "arial.ttf", $tekst_przycisku);

  $tekst_prawy=$bbox[2];  //prawa wsprzdna
  $tekst_lewy=$bbox[0];  //lewa wsprzdna
  $szerokosc_tekstu=$tekst_prawy - $tekst_lewy; // jak szeroki?
  $wysokosc_tekstu=abs($bbox[7] - $bbox[1]); // jak wysoki?

} while($rozmiar_czcionki>8 &&
        ($wysokosc_tekstu>$wysokosc_obrazka_bez_marginesow ||
         $szerokosc_tekstu>$szerokosc_obrazka_bez_marginesow)
       );

if($wysokosc_tekstu>$wysokosc_obrazka_bez_marginesow ||
   $szerokosc_tekstu>$szerokosc_obrazka_bez_marginesow)
{
  // aden moliwy do odczytania rozmiar czcionki nie pasuje
  echo "Wprowadzony tekst nie pasuje do przycisku.<BR>";
}
else
{
  // odnaleziono pasujcy rozmiar czcionki
  // teraz naley obliczy jego wsprzdne
  
  $tekst_x=$szerokosc_obrazka/2.0 - $szerokosc_tekstu/2.0;
  $tekst_y=$wysokosc_obrazka/2.0 - $wysokosc_tekstu/2.0;

  if ($tekst_lewy < 0)
      $tekst_x += abs($tekst_lewy);  //Dodanie wspczynnika do lewej pozycji
  $nad_linia_tekstu=abs($bbox[7]); // jak wysoko nad podstaw?
  $tekst_y+=$nad_linia_tekstu;  //dodanie wspczynnika podstawy

  $tekst_y-=2; // wspczynnik dostosowania do ksztatu szablonu

  $bialy=ImageColorAllocate($ob, 255, 255, 255);

  ImageTTFText($ob, $rozmiar_czcionki, 0, $tekst_x, $tekst_y, $bialy, "arial.ttf",
               $tekst_przycisku);

  Header("Content_type: image.png");
  ImagePNG($ob);
}

ImageDestroy($ob);
?>
