<?php
// doczenie kodu wspuytkowanego
include '../lib/config.php';

// odczytanie parametrw wejciowych
$album = (isset($_GET['album'])) ? $_GET['album'] : '';
$album_p = BASEDIR . '/' . $album;

$file = (isset($_GET['file'])) ? $_GET['file'] : '';
$file_p = $album_p . '/' . $file;

// wygenerowanie widoku obrazka
if ($album && $file)
{
    // przekierowanie do listy albumw, jeeli album lub plik znajduje si
    // poza udostpnionym katlogiem gwnym albo nie istnieje
    if (strpos(realpath($album_p), BASEDIR) !== 0 ||
        strpos(realpath($file_p), BASEDIR) !== 0 || !file_exists($file_p))
    {
        header('Location: ' . htmlspecialchars($_SERVER['PHP_SELF']));
        exit();
    }
    ob_start();

    // cze do widoku albumu
    echo '<p><a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '?album='.
        urlencode($album) . '">&lt; Powrt do albumu ' . htmlspecialchars($album) .
        '</a></p>';

    switch (substr($file, strrpos($file, '.') + 1))
    {
        // pliki jpeg s doczane przy uyciu elementu img
        case 'jpg':
        case 'jpeg':
            echo '<img src="view.php?file=' . urlencode($album . '/' . 
                $file) . '" alt="' . htmlspecialchars($file) . '"/>';
            break;

        // pliki QuickTime s doczane przy uyciu elementw object/embed
        case 'mov':
            echo '<object type="video/quicktime" data="view.php?file=' .
                urlencode($album . '/' . $file) . '">';
            echo '<param name="movie" value="view.php?file=' .
                urlencode($album . '/' . $file) . '"/>';
            echo '<embed type="video/quicktime" src="view.php?file=' .
                urlencode($album . '/' . $file) . '"/>';
            echo '</object>';
 
            break;
        // przekierowanie, jeeli format pliku jest nieprawidowy
        default:
            header('Location: ' . htmlspecialchars($_SERVER['PHP_SELF']));
            exit();       
    }

    $GLOBALS['TEMPLATE']['content'] = ob_get_contents();
    ob_end_clean();
}

// wygenerowanie widoku albumu
else if ($album)
{
    // przekierowanie do listy albumw, jeeli album znajduje si
    // poza udostpnionym katlogiem gwnym albo nie istnieje
    if (strpos(realpath($album_p), BASEDIR) !== 0 || !file_exists($album_p))
    {
        header('Location: ' . htmlspecialchars($_SERVER['PHP_SELF']));
        exit();       
    }
    ob_start();

    // cze do listy albumw
    echo '<p><a href="' . htmlspecialchars($_SERVER['PHP_SELF']) . '">' .
        '&lt; Powrt do listy albumw</a></p>';

    // odczytanie opisu albumu, jeeli jest dostpny
    if (file_exists($album_p . '/desc.txt'))
    {
        echo '<p>' . nl2br(file_get_contents($album_p . '/desc.txt')) . '</p>';
    }

    // wczytanie listy obrazkw i plikw QuickTime
    $dir = opendir($album_p);
    $images = array();
    while($f = basename(readdir($dir)))
    {
        if($f == '.' || $f == '..') continue;

        if (!is_dir($f))
        {
            $ext = (substr($f, strpos($f, '.') + 1));
            if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'mov')
            {
                $images[] = $f;
            }
        }
    }
    closedir($dir);

    // posortowanie obrazkw
    natcasesort($images);

    // wywietlenie miniaturek w tabeli
    $counter = 0;
    $columns = 6;
    echo '<table border="1">';
    foreach ($images as $image)
    {
        if (0 == ($counter % $columns))
        {
            echo '<tr>';
        }
        echo '<td style="width: '. (100 / $columns) . '%; ';
        echo 'vertical-align: top; padding: 10px; text-align: center;">';

        printf ('<a href="%s?album=%s&file=%s"><img src="thumbnail.php?' .
            'file=%s" alt="%s"/></a> ',
            htmlspecialchars($_SERVER['PHP_SELF']),
            urlencode($album),
            urlencode($image),
            urlencode($album . '/' . $image),
            htmlspecialchars($image));

        echo '</td>';
        if (0 == (++$counter % $columns))
        {
            echo '</tr>';
        }
    }
    // wypenienie wiersza tabeli pustymi komrkami, jeli jest to konieczne
    while ($counter++ % $columns)
    {
        echo '<td>&nbsp;</td>';
    }
    if (substr(ob_get_contents(), -5) == '</td>')
    {
        echo '</tr>';
    }
    echo '</table>';

    $GLOBALS['TEMPLATE']['content'] = ob_get_contents();
    ob_end_clean();
}

// wygenerowanie domylnego widoku prezentujcego list dostpnych albumw
else
{
    ob_start();

    // odczytanie listy albumw
    $albums = array();
    $dir = opendir(BASEDIR);
    while($f = basename(readdir($dir)))
    {
        if($f == '.' || $f == '..') continue;
        
        if (is_dir(BASEDIR . '/' . $f))
        {
            $albums[] = $f;
        }
    }
    closedir($dir);

    // posortowanie albumw
    natcasesort($albums);

    // wywietlenie listy albumw
    echo '<p>Albumy</p>';
    echo '<ul>';
    foreach ($albums as $album)
    {
        printf('<li><a href="%s?album=%s">%s</a></li>',
        htmlspecialchars($_SERVER['PHP_SELF']),
        urlencode($album),
        htmlspecialchars($album));
    }
    echo '</ul>';

    $GLOBALS['TEMPLATE']['content'] = ob_get_contents();
    ob_end_clean();
}

echo $GLOBALS['TEMPLATE']['content'];
?>
