<?php
// klasa formatujca tekst ze znacznikami BBCode do postaci kodu HTML
// wicej informacji na http://www.phpbb.com/community/faq.php?mode=bbcode
function format_bbcode($string)
{
    // funkcja wewntrzna, zastpujca znaczniki BBCode odpowiednimi znacznikami HTML
    function _format_bbcode($string)
    {
        // identyfikacja i wyodrbnienie znacznikw BBCode przy uyciu wyrae regularnych
        while (preg_match('|\[([a-z]+)=?(.*?)\](.*?)\[/\1\]|', $string, $part,
            PREG_OFFSET_CAPTURE))
        {
            $part[2][0] = str_replace('"', "", $part[2][0]);
            $part[2][0] = str_replace("'", "", $part[2][0]);
            $part[3][0] = _format_bbcode($part[3][0]);
            switch ($part[1][0])
            {
                // przetwarzanie elementw pogrubienia, wyrnienia i podkrelenia
                case 'b':
                case 'i':
                case 'u':
                    $replace = sprintf('<%s>%s</%s>', $part[1][0], $part[3][0],
                        $part[1][0]);
                    break;

                // przetwarzanie elementu code
                case 'code':
                    $replace = '<pre>' . $part[3][0] . '</pre>';
                    break;

                // przetwarzanie styli kolorystycznych
                case 'color':
                    $replace = sprintf('<span style="color: %s">%s</span>',
                        $part[2][0], $part[3][0]);
                    break;

                // przetwarzanie elementu email
                case 'email':
                    $replace = sprintf('<a href="mailto:%s">%s<\a>',
                        $part[3][0], $part[3][0]);
                    break;

                // przetwarzanie definicji rozmiaru
                case 'size':
                    $replace = sprintf('<span style="font-size: %s">%s</span>',
                        $part[2][0], $part[3][0]);
                    break;

                // przetwarzanie cudzysoww
                case 'quote':
                    $replace = (empty($part[2][0])) ?
                        ('<blockquote><p>' . $part[3][0] .
                            '</p></blockquote>') :
                        sprintf('<blockquote><p>%s napisa(a):<br />%s</p>' .
                            '</blockquote>', $part[2][0], $part[3][0]);
                    break;

                // process image element
                case 'img':
                    $replace = '<img src="' . $part[3][0] . '" alt=""/>';
                    break;

                // przetwarzanie hipecza
                case 'url':
                    $replace = sprintf('<a href="%s">%s</a>', 
                        (!empty($part[2][0])) ? $part[2][0] : $part[3][0],
                        $part[3][0]));
                    break;

                // przetwarzanie list punktowanych
                case 'list':
                    $replace = str_replace('[*]', '</li><li>', $part[3][0]);
                    $replace = '<x>' . $replace;
                    switch ($part[2][0])
                    {
                        case '1':
                            $replace = str_replace('<x></li>',
                                '<ol style="list-style-type: decimal">',
                                $replace . '</ol>');
                            break;

                        case 'A':
                            $replace = str_replace('<x></li>',
                                '<ol style="list-style-type: upper-alpha">',
                                $replace . '</ol>');
                            break;

                        case 'a':
                            $replace = str_replace('<x></li>',
                                '<ol style="list-style-type: lower-alpha">',
                                $replace . '</ol>');
                            break;

                        default:
                            $replace = str_replace('<x></li>',
                                '<ul>', $replace . '</ul>');
                            break;
                    }
                    break;

                default:
                    $replace = $part[3][0];
                    break;
            }
            $string = substr_replace($string, $replace, $part[0][1],
                strlen($part[0][0]));
        }
        return $string;
    }

    // zastpienie znacznikw
    $string = _format_bbcode($string);

    // wyczyszczenie znakw koca wiersza i dodanie znacznikw akapitw i koca wiersza
    $string = str_replace("\r\n\r\n", '</p><p>', $string);
    $string = str_replace("\n\n", '</p><p>', $string);
    $string = str_replace("\r\n", '<br />', $string);
    $string = str_replace("\n", '<br />', $string);
    $string = '<p>' . $string . '</p>';
    
    return $string;
}
?>