<?php
define('SOI', pack('n', 0xFFD8));  // znacznik pocztku obrazka jpeg
define('EOI', pack('n', 0xFFD9));  // znacznik koca obrazka jpeg

class MovThumbnail
{
    public $width;  // maksymalna szeroko miniaturki
    public $height; // maksymalna wysoko miniaturki

    // zainicjowanie obiektu MovThumbnail
    public function __construct($width = 100, $height = 100)
    {
        $this->width = $width;
        $this->height = $height;
    }
    
    // przyjcie lokalizacji pliku rdowego i zwrcenie otwartego
    // uchwytu obrazka albo zapisanie obrazka na dysku, jeeli wskazano
    // lokalizacj docelow
    public function generate($src, $dest = '')
    {
        // odszukanie pierwszego znacznika SOI
        for (
          $fp = fopen($src, 'rb'), $bytes = null;
          $bytes != SOI && !feof($fp);
          $bytes = fread($fp, 2)
        );

        // wyodrbnienie obrazka jpeg
        for (
          $buffer = $bytes;
          $bytes != EOI && !feof($fp);
          $bytes = fread($fp, 2), $buffer .= $bytes
        );

        // utworzenie obrazka z bufora
        $img = imagecreatefromstring($buffer);

        // odczytanie wymiarw obrazka
        $width = imagesx($img);
        $height = imagesy($img);

        // ustalenie, czy konieczna jest zmiana rozmiaru
        if(($lowest = min($this->width / $width, $this->height / $height)) < 1)
        {
            // zmiana rozmiaru
            $sm_width = floor($lowest * $width);
            $sm_height = floor($lowest * $height);
            $buffer = imagecreatetruecolor($sm_width, $sm_height);
            imagecopyresized($buffer, $img, 0,0, 0,0, $sm_width, $sm_height,
                $width, $height);
            imagedestroy($img);
            $img = $buffer;
        }

        // zapisanie obrazka na dysku lub zwrcenie uchwytu otwartego obrazka
        if ($dest)
        {
            imagejpeg($img, $dest, 100);
            imagedestroy($img);
        }
        else
        {
            return $img;
        }
    }
}
?>