<?php
    /* Klasa InvalidEmailException informuje
       administratora, że adres email został uznany za nieprawidłowy. */
    class InvalidEmailException extends Exception {
        function __construct($message, $email) {
            $this->message = $message;
            $this->notifyAdmin($email);
        }
        
        private function notifyAdmin($email) {
            mail("admin@example.org","NIEPRAWIDŁOWY ADRES EMAIL",$email,"From:web@example.com");
        }
    }
    
    /* Klasa Subscribe sprawdza poprawność adresu poczty elektronicznej
       i dodaje go do bazy danych. */
    class Subscribe {
        function validateEmail($email) {
            try {
                if ($email == "") {
                    throw new Exception("Należy podać adres email!");
                } else {
                    list($user,$domain) = explode("@", $email);
                    if (! checkdnsrr($domain, "MX"))
                        throw new InvalidEmailException(
                            "Podany adres email nie jest prawidłowy!", $email);
                    else
                        return 1;
                }
            } catch (Exception $e) {
                echo $e->getMessage();
            } catch (InvalidEmailException $e) {
                echo $e->getMessage();
                $e->notifyAdmin($email);
            }
        }
        
        /* Dodanie adresu email do bazy danych */
        function subscribeUser() {
            echo $this->email." dodany do bazy danych!";
        }
    }
    
    // Zakładamy, że adres został podany w formularzu subskrypcji
    $_POST['email'] = "someuser@example.com";
    /* Próba weryfikacji poprawności adresu i dodania go do bazy danych. */
    if (isset($_POST['email'])) {
        $subscribe = new Subscribe();
        if($subscribe->validateEmail($_POST['email']))
            $subscribe->subscribeUser($_POST['email']);
    }
?>