<?php
    $host = "ldap.wjgilmore.com";
    $port = "389";
    
    $dn = "dc=WJGilmore,dc=com";
    
    $connection = ldap_connect($host)
                  or die("Nie można nawiązać połączenia LDAP");
                  
    ldap_set_option($connection, LDAP_OPT_PROTOCOL_VERSION, 3);
    
    ldap_bind($connection)
            or die("Nie można wykonać operacji powiązania.");
            
    // Pobranie wszystkich rekordów osób, których imiona zaczynają
    // się na literę K 
    $results = ldap_search($connection, $dn, "givenName=K*");
    
    // Zapis rekordów do tablicy
    $entries = ldap_get_entries($connection, $results);
    
    // Określenie liczby zwróconych rekordów
    $count = $entries["count"];
    
    // Przejrzenie tablicy i wyświetlenie imion i adresów
    // wszystkich zwróconych osób.
    for($x=0; $x < $count; $x++) {
        printf("%s ", $entries[$x]["cn"][0]);
        printf("(%s) <br />", $entries[$x]["mail"][0]);
    }
?>