<?php
include_once("trig.php");

$IMAGE_WIDTH = 600;
$IMAGE_HEIGHT = 300;
$CENTER_FINDING_ITERATIONS = 20;

function imagecircle ($image, $center_x, $center_y,
 	              $radius, $color) 
{
  $diameter = $radius * 2;
  imagearc($image, $center_x, $center_y, 
	   $diameter, $diameter, 0, 360,
           $color);
}

function venn_visualization 
  ($left_amount, $left_name,
   $right_amount, $right_name, 
   $intersection_amount)
{
  global $IMAGE_HEIGHT, $IMAGE_WIDTH, 
         $CENTER_FINDING_ITERATIONS;
  // --- utworzenie obrazka i alokacja kolorw
  $image = imagecreate($IMAGE_WIDTH, $IMAGE_HEIGHT)
    or die("Nie udao si utworzy obrazka");
  $background_color = ImageColorAllocate($image, 255,255,255);
  $left_color = ImageColorAllocate($image, 100, 100, 200);
  $right_color = ImageColorAllocate($image, 200, 100, 100);
  $intersection_color = ImageColorAllocate($image, 225, 225, 225);
  $black_color = ImageColorAllocate($image, 0,0,0);

  // --- okrelenie wielkoci k
  $max_radius = min((($IMAGE_HEIGHT * 0.9) / 3),
	            (($IMAGE_WIDTH * 0.9) / 4));
  $center_y = $IMAGE_HEIGHT / 3.0;
  $default_center_x_left = $IMAGE_WIDTH / 4.0;
  $default_center_x_right = (3 * $IMAGE_WIDTH) / 4.0;
  $middle_x = $IMAGE_WIDTH / 2.0;
  $radius_left_side_raw =
    area_to_radius($left_amount);
  $radius_right_side_raw =
    area_to_radius($right_amount);
  $intersection_radius_raw = 
    area_to_radius($intersection_amount);
  $scale_factor = $max_radius /
                  (max($radius_left_side_raw,
                       $radius_right_side_raw));
  $radius_left_side = $radius_left_side_raw * $scale_factor;
  $radius_right_side = $radius_right_side_raw * $scale_factor;
  // (wygodnie jest udawa, e obszar czci wsplnej ma 
  //  promie (chocia nie jest koem), co pozwoli policzy
  //  wszystko tak samo, jak by to byo koo)
  $intersection_radius = $intersection_radius_raw * $scale_factor;
  $area_left_side = M_PI * 
                    $radius_left_side * $radius_left_side;
  $area_right_side = M_PI * 
                    $radius_right_side * $radius_right_side;
  $intersection_area = M_PI * 
                    $intersection_radius * $intersection_radius;

  // W tym miejscu mamy ju wszystkie potrzebne informacje oprcz
  // pooenia rodkw k.
  // Cztery przypadki:
  // 1) brak czci wsplnej 2) czciowe przecicie
  // 3) lewy jest podzbiorem prawego
  // 4) prawy jest podzbiorem lewego

  if ($intersection_amount == 0) {
    // Brak przecicia
    $center_x_left = $default_center_x_left;
    $center_x_right = $default_center_x_right;
    $left_fill_x = $center_x_left;
    $right_fill_x = $center_x_right;
    $intersection_fill_x = -1;
  }
  else if (($intersection_area < $area_left_side) &&
           ($intersection_area < $area_right_side)) {

    // Skomplikowany przypadek --- musimy okreli gdzie
    // powinny znajdowa si rodki k tak, eby ich przecicie
    // by proporcjonalne do czci wsplnej zbiorw
    // Najpierw wywoujemy funkcj, ktra oblicza jak daleko
    // powinny by rodki od siebie
    
    $center_distance = 
      find_center_distance($radius_left_side, $radius_right_side,
                           $intersection_area, 
                           $CENTER_FINDING_ITERATIONS);

    // Gdy ju znamy t odlego, to umieszczamy rodki k
    // w przyblieniu na rodku obrazka
    $center_x_left = $middle_x  // lewy/prawy rodek obrazka
                     - ($center_distance *
                        ($radius_left_side / 
                          ($radius_left_side +
                            $radius_right_side)));
    $center_x_right = $middle_x  // lewy/prawy rodek obrazka
                     + ($center_distance *
                        ($radius_right_side / 
                          ($radius_left_side +
                            $radius_right_side)));
    
    // obliczylimy rozmiar i rodki k.
    // Teraz trzeba okreli dobre punkty do rozpoczcia
    // kolorowania trzech rnych regionw
    $left_fill_x = 
      (($center_x_left - $radius_left_side) + 
       ($center_x_right - $radius_right_side)) 
      / 2.0;
    $right_fill_x = 
      (($center_x_left + $radius_left_side) + 
       ($center_x_right + $radius_right_side)) 
      / 2.0;
    $intersection_fill_x = 
       (($center_x_right - $radius_right_side) +
        ($center_x_left + $radius_left_side)) 
        / 2.0;
  }
  else if (($intersection_area == $area_left_side) &&
           ($intersection_area < $area_right_side)) {
    // Lewy zbir w caoci mieci si w prawym
    // Trzeba go umieci gdzie w rodku 
    // prawego 
       
    $center_x_right = $middle_x;
    $center_x_left = $middle_x - 
       ($radius_right_side - $radius_left_side) / 2;
    $left_fill_x = -1;
    $right_fill_x = 
      (($center_x_left + $radius_left_side) + 
       ($center_x_right + $radius_right_side)) 
      / 2.0;
    $intersection_fill_x = $center_x_left;
  }
  else if ($intersection_area == $area_right_side) {
    $center_x_left = $middle_x;
    $center_x_right = $middle_x +
       ($radius_left_side - $radius_right_side) / 2;
    $right_fill_x = -1;
    $left_fill_x = 
      (($center_x_left - $radius_left_side) + 
       ($center_x_right - $radius_right_side)) 
      / 2.0;
    $intersection_fill_x = $center_x_right;
  }

  // rysowanie i wypenianie obszarw
  imagecircle($image, $center_x_left, $center_y,
              $radius_left_side, $black_color);             
  imagecircle($image, $center_x_right, $center_y,
            $radius_right_side, $black_color);             
  if ($left_fill_x > 0) {
    imagefill($image, $left_fill_x, 
              $center_y, $left_color);
  }
  if ($right_fill_x > 0) {  
    imagefill($image, $right_fill_x, 
              $center_y, $right_color);
  }
  if ($intersection_fill_x > 0 ) {
     imagefill($image, $intersection_fill_x, 
               $center_y, $intersection_color);
  }
  $left_hand_text = "$left_name ($left_amount)";
  $right_hand_text = "$right_name ($right_amount)";
  $intersection_text = "Cz wsplna: $intersection_amount";
  left_label($image, $left_hand_text, $left_color);
  right_label($image, $right_hand_text, $right_color);
  intersection_label($image, $intersection_text, $black_color);
  
  // przesanie obrazka 
  header("Content-type: image/png");
  imagepng($image);
  imagedestroy($image);
}

function left_label ($image, $label_string, $color) {
  global $IMAGE_WIDTH, $IMAGE_HEIGHT;
  imagestring($image, 5, 
              ($IMAGE_WIDTH / 4.0 -
                (imagefontwidth(5) * strlen($label_string))
                 / 2),
              $IMAGE_HEIGHT - 55.0,
              $label_string, $color);
}

function right_label ($image, $label_string, $color) {
  global $IMAGE_WIDTH, $IMAGE_HEIGHT;
  imagestring($image, 5, 
              ($IMAGE_WIDTH * 3 / 4.0 -
                (imagefontwidth(5) * strlen($label_string))
                 / 2),
              $IMAGE_HEIGHT - 55.0,
              $label_string, $color);  
}

function intersection_label ($image, $label_string, $color) {
  global $IMAGE_WIDTH, $IMAGE_HEIGHT;
  imagestring($image, 2, 
              ($IMAGE_WIDTH / 2.0  -
                (imagefontwidth(2) * strlen($label_string))
                 / 2),
              $IMAGE_HEIGHT - 30.0,
              $label_string, $color);
}

function find_center_distance ($r1, $r2, $desired_area,
                               $iterations) {
  // Najwiksza moliwa odlegoc to r1 + r2, a
  // najmniejsza to abs(r1 - r2). Zaczynamy w rodku.                             
                               
  $distance_guess = (($r1 + $r2) + abs($r1 - $r2)) / 2.0;
  $distance_increment = (($r1 + $r2) - abs($r1 - $r2)) / 4.0;
  for ($x = 0; $x < $iterations; $x++) {
    $calculated_area = 
      circle_intersection_area($r1, $r2, $distance_guess);
    if ($calculated_area < $desired_area) {
      // przesunicie rodkw bliej siebie
      $distance_guess -= $distance_increment;
      $distance_increment *= 0.5;
    }
    else if ($calculated_area > $desired_area) {
      // przesunicie rodkw od siebie
      $distance_guess += $distance_increment;
      $distance_increment *= 0.5;
    }
    else {
      // nieprawdopodobne, ale kto to wie...
      break;
    }
  }
  return($distance_guess);
}
?>
