<!-- Listing 47-3: Skrypt do zbierania danych z pliku HTML (harvest.php) -->
<?php
// harvest.php - pobiera dane o filmach z plikw HTML MysteryGuide

$file = 'sample_HTML_for_harvesting.html';
$fp = fopen($file, "r");
$file_str = fread($fp, filesize($file));

// Podzia strony na kawaki odpowiadajce tabelom
$tables = explode('</td></tr></table>', $file_str);

// Nie na kadej stronie s jedynie tabele, wic 
// trzeba zmieni nazw tabeli tak, eby bya bardziej informacyjna. 
// Jeli wszystkie strony maj identyczne sekcje, to nie trzeba tego robi
foreach ($tables as $table_val) {
  if (strpos($table_val, 'SIZE=+3') > 30) {
    $chunk['review'] = $table_val;
  } elseif (strpos($table_val, '<b>Further reading</b>') > 1) {
    $chunk['further'] = $table_val;
  }  elseif (strpos($table_val, '<b>Summary information</b>') > 1) {
    $chunk['summary'] = $table_val;
  }  elseif (strpos($table_val, '<b>Top 5') > 1) {
    $chunk['top5'] = $table_val;
  }  elseif (strpos($table_val, '<b>By the same') > 1) {
    $chunk['sameauthor'] = $table_val;
  }  elseif (strpos($table_val, '<b>Movies</b>') > 1) {
    $chunk['movie'] = $table_val;
  }
}

// Teraz przechodzimy do informacji o filmach
if (isSet($chunk['movie'])) {
  // Pobieramy wszystko, co wystpuje po sowie "Movies"
  $movie_str = strstr($chunk['movie'], 'Movies');
  
  // Teraz pobieramy same dane dotyczce filmu
  $movie_data_str = strstr($movie_str, '<font SIZE=-2 FACE="ARIAL, GENEVA, SANS-SERIF">');
  $movie_data = substr($movie_data_str, 47); // pozbywamy si znacznika font
  //echo $movie_data;

  // Teraz mona zrobi z tym napisem co si chce, na przykad umieci w bazie danych...
}

?>
