<?php
include_once("certainty_utils.php");

class Question 
{
  // ZMIENNE PRYWATNE
  private $_id; // identyfikator w bazie danych
  private $_question; // tre pytania
  private $_answer; // poprawna numeryczna odpowied
  private $_lowerLimit; // najmniejsza moliwa warto dolnego ograniczenia
  private $_upperLimit; // najwiksza moliwa warto grnego ograniczenia
  private $_distractorCount; // liczba prezentowanych moliwoci wyboru
  private $_scalingType;  // reprezentacja liniowa lub geometryczna
  private $_distractorArray; // zawiera wszystkie moliwe odpowiedzi
  private $_lowerGuess = NULL; // dolne ograniczenie podane przez gracza
  private $_upperGuess = NULL; // grne ograniczenie podane przez gracza
  private $_correct = NULL;  // TRUE lub FALSE po odpowiedzi

  // KONSTRUKTOR
  function __construct($id, $question,
                       $answer, 
                       $lower_limit,
                       $upper_limit,
                       $distractor_count,
                       $scaling_type) {
    $this->_id = $id;
    $this->_question = $question;
    $this->_answer = $answer;
    $this->_lowerLimit = $lower_limit;
    $this->_upperLimit = $upper_limit;
    $this->_distractorCount = $distractor_count;
    $this->_scalingType = $scaling_type;
    $this->_distractorArray =
        $this->_makeDistractors($lower_limit, 
                   $upper_limit,
                   $distractor_count,
                   $scaling_type);
  }

  // FUNKCJE PUBLICZNE

  // akcesory

  function getId () {return($this->_id);}
  function getQuestion () {return($this->_question);}
  function getAnswer () {return($this->_answer);}
  function getCorrect() {return($this->_correct);}
  function rightAnswer() {return($this->_correct);}
  function getDistractorCount() {return($this->_correct);}
  function getScalingType() {return($this->_scalingType);}
  function getDistractorArray() {return($this->_distractorArray);}
  function getLowerGuess() {return($this->_lowerGuess);}
  function getUpperGuess() {return($this->_upperGuess);}

  function getAnswerSpread () {
    $answer_range = count($this->_distractorArray) - 1;
    if (IsSet($this->_lowerGuess) &&
        IsSet($this->_upperGuess)) {
      $lower = $this->_lowerGuess;
      $upper = $this->_upperGuess;
      if ($upper < $lower) {
	throw new Exception("Problem z zakresem odpowiedzi");
      }
      else {
        $spread = 
               (max($upper - $lower, 1) - 1)
               / ($answer_range - 1);
        return($spread);
      }
    }
    else {
      throw new Exception("Nie podano odpowiedzi");
    }
  }

  function updateWithAnswer($lower, $upper) {
    // argumentami s ograniczenia podane przez gracza i 
    // sprawdzane jest, czy prawidowa odpowied si w nich mieci
    $this->_lowerGuess = $lower;
    $this->_upperGuess = $upper;
    $upper_value = NULL;
    $lower_value = NULL;
    $count = 1;
    foreach ($this->_distractorArray as $distractor) {
      if ($count == $lower) {
        $lower_value = $distractor;
      }
      if ($count == $upper) {
        $upper_value = $distractor;
      }
      $count++;
    }
    if (IsSet($lower_value) && IsSet($upper_value)) {
      $answer = $this->_answer;
      $lower_value_lowered = $lower_value -
        max(0.0001, abs($lower_value / 1000000.0));
      $upper_value_raised = $upper_value +
        max(0.0001, abs($upper_value / 1000000.0));
      if (($lower_value_lowered <= $this->_answer) &&
          ($upper_value_raised >= $this->_answer)) {
        $this->_correct = TRUE;        
      }
      else {
        $this->_correct = FALSE;
      }
    }
    else {
      $this->_correct = NULL;
    }
  }

  // FUNKCJE PRYWATNE
  private function _makeDistractors ($lower, $upper,
                             $distractor_count,
                             $linear_or_geometric)
  // Tworzy tablic wartoci porednich midzy 
  // najwyszym i najniszym moliwym wynkiem. 
  // Spord tych wartoci gracz moe wybiera odpowiedzi.
  // W zalenoci od flagi, innej dla kadego pytania
  // w bazie danych, moliwe odpowiedzi mog by wyliczane
  // liniowo (10, 20, 30 ...) lub z postpem geometrycznym
  // (10, 20, 40, 80 ...)                            
  // Kod wyliczajcy wartoci dla postpu geometrycznego
  // moe, dla niektrych wartoci argumentw wylecie 
  // w powietrze, dlatego s one sprawdzane przed wywoaniem
  // make_distractors_geometric. Bdy powoduj przejcie do
  // liniowego sposobu obliczania wartoci porednich.
  {
    if (($linear_or_geometric == CERTAINTY_GEOMETRIC) &&
        ($this->safeGeometricArguments($upper, $lower))) {
       return($this->_makeDistractorsGeometric(
         $lower, $upper, $distractor_count));
    }
    else {
      return($this->_makeDistractorsLinear(
         $lower, $upper, $distractor_count));
    }
  }

  private function safeGeometricArguments ($upper, $lower) {
   // powinno pewnie te zawiera jako argument liczb 
   // odpowiedzi do wyboru. Testowane byo tylko dla 
   // okoo 10 takich odpowiedzi. 
   return (($upper > 0) && ($lower > 0) &&
           ($upper > $lower) &&
           (($upper / $lower) < 10000000000));
  }

  private function _makeDistractorsLinear
           ($lower, $upper, $distractor_count) 
  {
    
    $return_array = array();
    array_push($return_array, round_to_digits($lower, 3));
    $current = $lower;
    $increment = (($upper - $lower) / $distractor_count);
    // dodawanie we wszystkich moliwych wartociach
    for ($x = 1; $x < $distractor_count; $x++) {
      array_push($return_array, 
                 round_to_digits($lower + 
  	                         ($x * $increment),
                                 3));
    }
    array_push($return_array, round_to_digits($upper, 3));
    return($return_array);
  }

  private function _makeDistractorsGeometric
           ($lower, $upper, $distractor_count) 
  {
    if (($lower >= $upper) ||
        ($distractor_count < 2)) {
      die("Argumentami _makeDistractorsGeometric powinny by" . 
          "1) najmniejsza moliwa warto, 2) najwiksza moliwa warto, ".
          "3) licznik (>=2) wartoci midzy nimi.<BR>" .
          "Argumentami s 1) $lower, 2) $upper, 3) $distractor_count<BR>");
    }   
    $return_array = array();
    array_push($return_array, round_to_digits($lower, 3));
    $limit_ratio = $upper / $lower;
    $root = nth_root($limit_ratio, $distractor_count);
    $current = $lower;
    // dodawanie do wartoci porednich
    for ($x = 1; $x < $distractor_count; $x++) {
      $distractor = round_to_digits(
                      $lower * pow($root, $x),
                      3);
      array_push($return_array, 
                 $distractor);
    }
    array_push($return_array, round_to_digits($upper, 3));
    return($return_array);
  }
}
?>
