<?php 
include_once("game_class.php");
include_once("game_text_class.php");

class GameDisplay
{
  //    prezentacja
  public $_pageTitle = "Quiz pewnoci";
  public $_blueColor = "#AAAAFF";
  public $_redColor = "#FFAAAA";

  //    zawarto
  public $_game = NULL;
  public $_gameText;
  public $_highScorePosted = FALSE;
  
  // KONSTRUKTOR

  function __construct ($game) {
    $this->_game = $game;
    $this->_gameText = new GameText();
  }

  // FUNCKJE PUBLICZNE
  //   akcesory
  function getPageTitle() {
    return($this->_pageTitle);
  }
  function getBlueColor() {
    return($this->_blueColor);
  }
  function getRedColor() {
    return($this->_redColor);
  }
  function getGame() {
    return($this->_game);
  }
  function getHighScorePosted() {
    return($this->_highScorePosted);
  }

  function updateWithAnswer ($lower, $upper) {
    $game = $this->getGame();
    $game->updateWithAnswer($lower, $upper);
  }

  function makeErrorPage ($problem_string) {
    // tworzy stron HTML wywietlan gdy
    // stao si co bardzo nieprawidowego
    $top_matter_string = 
       $this->_makeTopMatter($this->_pageTitle);
    $page_string = <<<EOT
$top_matter_string
</H2></CENTER>
<TABLE BORDER=2>
<TR>
<CENTER>
<H2>Przepraszamy, ale gra nie jest aktualnie 
dostpna.</H2><H4>($problem_string)</H4>
</CENTER>
</TR></TABLE>
</BODY></HTML>
EOT;
    return($page_string);
  }

  function display () {
    // zwraca ca stron jako jeden napis ---
    // gwn struktur stron oraz 
    // moliwe do napisania metody wypisujce poszczeglne komponenty
    
    // sprawdzenie poprawnoci
    if (!$this->_game ||
        !is_object($this->_game)) {
      throw new 
	Exception("Nie mona znale wanego obiektu gry");
    }
    elseif (!$this->_game->getDbConnection()) {
      throw new 
	Exception("Brak poczenia z baz danych");
    }

    // wywietlenie poprawnej strony
    else {
      $top_matter_string = 
        $this->_makeTopMatter($this->_pageTitle);
      $current_question = 
        $this->_currentQuestionString();
      $previous_question = 
        $this->_previousQuestionString();
      $game_state = 
        $this->_gameStateString();
      $introduction = 
        $this->_gameText->introduction();
      $rules = 
        $this->_gameText->rules();
      if ($this->_game->getGameLost()) {
        $left_side = 
          $this->_gameText->gameLostText() .
          $this->_highScoreString();
      }
      elseif ($this->_game->getGameWon()) {
        $left_side = 
          $this->_gameText->gameWonText() .
          $this->_highScoreString();
      }
      else {
        $left_side = $current_question;
      }
      if ($this->_game->getPreviousQuestion()) {
         $right_side = 
           "<TABLE><TR><TD>
           $previous_question
           </TD></TR><TR><TD>
           $game_state
           </TD></TR><TR><TD>
           $rules
           </TD></TR></TABLE>";
      }
      else {
         $right_side = 
           "<TABLE><TR><TD>
           $introduction
           </TD></TR>
           <TR><TD>
           $rules
           </TD></TR><TR><TD>  
           $game_state
           </TD></TR>
           </TABLE>";
      }
    
    // waciwa konstrukcja strony
$page_string = <<<EOT
$top_matter_string
</H2></CENTER>
<TABLE BORDER=2>
<TR>
<TD VALIGN=TOP WIDTH=40% >$left_side</TD>
<TD VALIGN=TOP WIDTH=60% >$right_side</TD>
</TR></TABLE>
</BODY></HTML>
EOT;
      return($page_string);
    }
  }

  function handleHighScore () { 
    // Obsuguje aktualizacj bazy danych w przypadku, gdy
    // gracz osign najwyszy wynik i przesa swoje imi
    // do zapisania
    if (!$this->_highScorePosted) {
      $this->_highScorePosted = TRUE;
      if (get_post_value('NICKNAME') &&
          get_post_value('ANSWER_COUNT') &&
          get_post_value('CREDIT') &&
          get_post_value('CHECKSUM') &&
          $this->_checksumChecks(
            get_post_value('ANSWER_COUNT'),
            get_post_value('CREDIT'),
            get_post_value('CHECKSUM'))) {
        $name = get_post_value('NICKNAME');
        $answer_count = get_post_value('ANSWER_COUNT');
        $credit = get_post_value('CREDIT');
        $query = "insert into high_scores
                  (name, answer_count, credit)
                  values 
                  ('$name', $answer_count, $credit)";
        $connection = 
         $this->_game->gameParameters->getDbConnection();
        $result = mysql_query($query, $connection);
      }
      else {
        // nic nie robimy -- bd przy dodawaniu najlepszego wyniku
        // nie powinien wszystkiego psu
      }
    }
  }

  // FUNKCJE PRYWATNE

  private function _makeTopMatter ($title) {
    // zwraca fragment HTML, ktry wystpuje w nagwku
    // zarwno normalnej storny, jaki i powiadomienia o bdzie
    // i zawiera nagwek HTML oraz tytu
    $return_string = <<<EOT
<HTML><HEAD><TITLE>$title</TITLE></HEAD>
<BODY BGCOLOR=#FFFFFF><CENTER>
<H1>$title<BR>
<FONT SIZE=-1 COLOR=BLUE>
(Jak bardzo <B>jeste</B> pewny?)</FONT>
</H1></CENTER>
EOT;
    return($return_string);
  }

  private function _currentQuestionString () {
    $PHP_SELF = $_SERVER['PHP_SELF'];
    return("<H2>" .
           $this->_game->getCurrentQuestionText() .
           "</H2>" .
           "<FORM METHOD=POST ACTION=\"$PHP_SELF\">" .
           "<INPUT TYPE=HIDDEN NAME=POSTCHECK VALUE=1>" .
           $this->_distractorString(
              $this->_game->getCurrentQuestion()) .
           "</FORM>");
  }

  private function _distractorString ($question) {
    // tworzy HTML do prezentacji przyciskw wyboru
    // dla odpowiedzi. Zakada, e tablica 
    // reprezentujca wywietlane moliwoci zostaa
    // wczeniej utworzona i mona j pobra 
    // z pytania (question) przy uyciu 
    // get DistractorArray
    $distractor_array = $question->getDistractorArray();
    $distractor_string = "<TABLE><TR VALIGN=TOP><TD>";
    $distractor_string .= 
      "<TABLE BORDER=1 BGCOLOR=\"AAAAFF\"><TR><TH> 
        </TH><TH>Przynajmniej</TH><TH>Nie wicej ni</TH>";
    $count = 1;  // etykiety zaczynajce si od 1 s lepsze
                 // bo mona uy po prostu if($label)
    $total = count($distractor_array);
    foreach ($distractor_array as $distractor) {
      $lower_selected = ($count == 1) ?
        "CHECKED" : "";
      $upper_selected = ($count == $total) ?
        "CHECKED" : "";
      $formatted_distractor = 
         ($distractor >= 10000) ?
            number_format($distractor) : $distractor;
      $distractor_string .= 
        "<TR><TD>$formatted_distractor</TD>
             <TD><INPUT TYPE=RADIO NAME=\"lower\"
                  VALUE=$count 
                  $lower_selected ></TD>\n" .
        "<TD><INPUT TYPE=RADIO NAME=\"upper\"
             VALUE=$count
             $upper_selected ></TD></TR>\n";
      $count++;
    }
    $distractor_string .= "</TABLE>";
    $distractor_string .= "</TD><TD>";
    $distractor_string .= 
       "<INPUT NAME=\"Submit guess\" VALUE=\"Przelij odpowied\"
               TYPE=SUBMIT>";
    $distractor_string .= "</TD></TR></TABLE>";

    return($distractor_string);
  }

  private function _previousQuestionString () {
    if (!$this->_game->getPreviousQuestion()) {
      $return_string = "";
    }
    else {
      $return_string =
        $this->_game->previousQuestionCorrect() ? 
          $this->_rightString() :
          $this->_wrongString();
    }
    return($return_string);
  }

  function _rightString () {
    return("<H1><FONT COLOR=GREEN>DOBRZE!</FONT></H1>");
  }

  function _wrongString () {
    return("<H1><FONT COLOR=RED>LE!</FONT></H1>");
  }

  private function _highScoreEligible () { 
    // pobiera kocowy wynik gry i odpytuje baz danych
    // eby sprawdzi, czy gracz nadaje si na 
    // list najlepszych wynikw
    $query = "select name, answer_count, credit
              from high_scores
              order by answer_count desc, credit desc
              limit 10";
    $connection = 
      $this->_game->getDbConnection();
    if ($connection && is_resource($connection)) {
      $result = mysql_query($query, $connection);
      $eligible = false;
      if (mysql_num_rows($result) > 9) {
        while ($row = mysql_fetch_assoc($result)) {
          $answer_count = $row['answer_count'];
          $credit = $row['credit'];
          if (($this->_game->getCorrectAnswers()
                > $answer_count) ||
              (($this->_game->getCorrectAnswers() 
                 == $answer_count) &&
               ($this->_game->_credit > $credit))) {
            $eligible = TRUE;
            break;
          }
        }
      }
      else {
        $eligible = TRUE;
      }
      return($eligible);
    }
    else {
      throw new
        Exception("Gra nie ma poczenia z baz danych");
    }
  }
  
  // W trakcie przesyania wyniku obliczana jest suma kontrolna
  // (mieszczca w sobie liczb poprawnych odpowiedzi i kocowy 
  // kredyt) i jest ona porwnywana z przesanymi wynikami.
  // Jest to pierwsza linia obrony przed oszustwem 
  // (dziaa oczywicie, jeli wzr obliczania tej sumy 
  // kontrolnej nie zostanie opublikowany w ksice, czy 
  // gdzie indziej)
  private function _checksumChecks ($answer_count, $credit,
                            $checksum) {
    return($checksum ==
           $this->_makeCheckSum($answer_count, $credit));
  }

  private function _makeChecksum ($answer_count, $credit) {
   return ((round($credit)) * 17) *
           ($answer_count * 31);
  }

  private function _postHighScoreString () {
    // Gratulacje oraz formularz HTML do przesania 
    // imienia na list najlepszych graczy
    $PHP_SELF = $_SERVER['PHP_SELF'];
    $answer_count = $this->_game->getCorrectAnswers();
    $credit = $this->_game->getCredit();
    $checksum = $this->_makeChecksum($answer_count, $credit);
    $result_string = 
      "<H2>Gratulacje! Masz jeden z najlepszych wynikw</H2>".
      "Wpisz swoje imi (albo ksywk) do umieszczenia ".
      "na licie najlepszych wynikw:".
      "<FORM METHOD=POST ACTION=\"$PHP_SELF\" >".
      "<INPUT NAME=NICKNAME TYPE=TEXT SIZE = 30>".
      "<INPUT NAME=ANSWER_COUNT TYPE=HIDDEN ".
        "VALUE=$answer_count>".
      "<INPUT NAME=CREDIT TYPE=HIDDEN ".
        "VALUE=$credit>".
      "<INPUT NAME=CHECKSUM TYPE=HIDDEN ".
        "VALUE=$checksum>".
      "<INPUT NAME=Submit TYPE=SUBMIT ".
        "VALUE=Przelij >".
      "<INPUT TYPE=HIDDEN NAME=POSTCHECK VALUE=1>" .
      "<INPUT TYPE=HIDDEN NAME=HIGHSCORE VALUE=1>" .
      "<FORM>";
    return($result_string);
  }

  private function _highScoreString () {
    // Tabela z najlepszymi wynikami wraz 
    // z odwoaniami do bazy danych sucymi do jej pobrania
    if ($this->_highScoreEligible() &&
        !$this->_highScorePosted) {
      $result_string = $this->_postHighScoreString();
    }
    else {
      $result_string = "";
    }
    $result_string .= 
     "<H2>Najlepsze wyniki</H2>".
     "<TABLE BORDER=1><TR><TH>Miejsce</TH>".
     "<TH>Imi</TH><TH>Poprawne odpowiedzi</TH>".
     "<TH>Pozostaly kredyt</TH></TR>";
    $query = "select name, answer_count, credit
              from high_scores
              order by answer_count desc, credit desc
              limit 10";
    $connection = 
      $this->_game->gameParameters->getDbConnection();
    if ($connection && is_resource($connection)) {
      $result = mysql_query($query, $connection);
      $rank = 1;
      while ($row = mysql_fetch_assoc($result)) {
        $name = $row['name'];
        $answer_count = $row['answer_count'];
        $credit = (int) ($row['credit']);
        $result_string .=
          "<TR><TH>$rank</TH><TD>$name</TD>".
          "<TD>$answer_count</TD><TD>$credit</TD></TR>";
        $rank++;
      }
      $result_string .= "</TABLE>";
      return($result_string);
    }
    else {
      throw new
        Exception("Gra nie ma poczenia z baz danych");
    }
  }

  private function _gameStateString () {
    // Tabela HTML
    $correct_answers = $this->_game->getCorrectAnswers();
    $credit = round_to_digits($this->_game->getCredit(), 2);
    $level = $this->_game->getLevel();
    return("<TABLE CELLPADDING=10>".
    "<TR BGCOLOR=$this->_blueColor><TH>W sumie dobrych odpowiedzi:</TH>".
    "<TD>$correct_answers</TD></TR>".
    "<TR BGCOLOR=$this->_redColor><TH>Pozostay kredyt:</TH>".
    "<TD>$credit</TD></TR>".
    "<TR BGCOLOR=$this->_blueColor><TH>Osignito poziom:</TH>".
    "<TD>$level</TD></TR></TABLE>");
  }
}
?>
