<?php
include_once("db_connection.php");
include_once("rating_functions.php");
include_once("content_functions.php");

$query_best = 
  "select quotations.ID, 
          quotations.quotation, 
          quotations.attribution, 
          avg(rating_values.rank) as avg_rank
   from quotations, ratings, rating_values
   where ratings.rated_id = quotations.id
         and ratings.rating_id = rating_values.id
   group by quotations.id
   order by avg_rank desc limit 10";

$result = $db->query($query_best);

if (DB::isError($result)) 
  {
  $errorMessage = $result->getMessage();
  die ($errorMessage);
  }

$table_rows_string =
"<TR><TH>Cytat</TH><TH>Autor</TH><TH>rednia ocena</TH></TR>";

while ($row_array = $result->fetchRow()) 
  {
    $quotation_id = $row_array['ID'];
    $quotation_text = $row_array['quotation'];
	$quotation_attribution = $row_array['attribution'];
    $avg_rank = $row_array['avg_rank'];
    $rounded_avg_rank = sprintf("%.1f", $avg_rank);
$table_rows_string .= 
    "<TR><TD><A HREF=\"rated_display.php?RATED_ID=$quotation_id\">
     $truncated_quotation</A></TD>
     <TD>$quotation_text</TD>".
    "<TD>$rounded_avg_rank</TD></TR>";
  }

$db->disconnect();

// ukad strony
$title = "Strona z ocenami cytatw";
$page_string = <<<EOP
<HTML><HEAD></HEAD><BODY>
<CENTER><H2>$title</H2></CENTER>
<TABLE BORDER=1>
<H2>Dziesi najpopularniejszych cytatw</H2>
$table_rows_string
</TABLE>
</BODY>
</HTML>
EOP;

echo $page_string;
?>
