<?php
$file = "recipe.xml";

// Wywoywana na pocztku kadego elementu
function startElement($parser, $name, $attrs) {
    print "<B>$name =></B>  ";
}

// Wywoywana na kocu kadego elementu
function endElement($parser, $name) {
    print "\n";
}

// Wywoywana dla danych znakowych
function characterData($parser, $value) {
    print "$value<BR>";
}

// Definiowanie analizatora
$simpleparser = xml_parser_create();
xml_set_element_handler($simpleparser, "startElement", "endElement");
xml_set_character_data_handler($simpleparser, "characterData");

// Otwarcie pliku XML do odczytu
if (!($fp = fopen($file, "r"))) {
  die("Nie mog otworzy pliku XML");
}

// Analiza
while($data = fread($fp, filesize($file))) {
if (!xml_parse($simpleparser, $data, feof($fp))) {
  die(xml_error_string(xml_get_error_code($simpleparser)));
  }
}

// Zwolnienie pamici
xml_parser_free($simpleparser);
?>