<?php
// Wersja PEAR listingu 9.4

require_once "Date/Calc.php";

function checkdob($birth_date)
{
  $date = new Date_Calc();

  if (empty($birth_date))
  {
    print "Pole daty urodzenia nie moe by puste.";
    return false;
  }
  elseif (!ereg("^([0-9]{2})/([0-9]{2})/([0-9]{4})$", 
          $birth_date, $parts))
  {
    print "Data urodzenia nie jest prawidow dat w formacie DD/MM/RRRR";
    return false;
  }
  elseif (!$date->isValidDate($parts[1], $parts[2], $parts[3]))
  {
    print "Data urodzenia jest nieprawidowa. Prosz sprawdzi, czy miesic
           jest pomidzy 1 i 12 a dzie jest prawidowy dla tego miesica.";
    return false;
  }
  elseif (intval($parts[3]) < 1902 || 
          $date->isFutureDate($parts[1], $parts[2], $parts[3]))
  {
    print "Musisz by ywy aby korzysta z tej witryny.";
    return false;
  }
  else
  {
    // Sprawdzenie, czy uytkownik ma 18 lat.
    if ($date->compareDates($parts[1], $parts[2], $parts[3],
        intval(date("d")), intval(date("m")), intval(date("Y"))-18) > 0)
    {
      print "Musisz mie co najmniej 18 lat aby korzysta z tej witryny.";
      return false;
    }
  }
  return true;
}
?>

