<?php
function checkdob($birth_date)
{
  if (empty($birth_date))
  {
    print "Pole daty urodzenia nie moe by puste.";
    return false;
  }
  // Sprawdzenie daty i podzia na czci $parts
  elseif (!ereg("^([0-9]{2})/([0-9]{2})/([0-9]{4})$", 
          $birth_date, $parts))
  {
    print "Data urodzenia nie jest prawidow dat w formacie DD/MM/RRRR";
    return false;
  }
  elseif (!checkdate($parts[2],$parts[1],$parts[3]))
  {
    print "Data urodzenia jest nieprawidowa. Prosz sprawdzi, czy miesic
           jest pomidzy 1 i 12 a dzie jest prawidowy dla tego miesica.";
    return false;
  }
  elseif (intval($parts[3]) < 1902 || 
          intval($parts[3]) > intval(date("Y")))
  {
    print "Musisz by ywy aby korzysta z tej witryny.";
    return false;
  }
  else
  {
    $dob = mktime(0, 0, 0, $parts[2], $parts[1], $parts[3]);

    // Sprawdzenie, czy uytkownik ma 18 lat.
    if ((float)$dob > (float)strtotime("-18years"))
    {
      print "Musisz mie co najmniej 18 lat aby korzysta z tej witryny.";
      return false;
    }
  }
  return true;
}
?>
