<?php
function backTrace($context)
{
   // Odczytanie cieki wywoa funkcji
   $trace = debug_backtrace();

   $calls = "\ncieka:";

   // Rozpoczcie od 2 -- ignorujemy t funkcj (0) oraz funkcj customHandler() (1)
   for($x=2; $x < count($trace); $x++)
   {
     $callNo = $x - 2;
     $calls .= "\n  {$callNo}: {$trace[$x]["function"]} ";
     $calls .= "(wiersz {$trace[$x]["line"]} w {$trace[$x]["file"]})";
   }

   $calls .= "\nZmienne w {$trace[2]["function"]} ():";

   // Odczytanie z $context informacji o zmiennych funkcji zawierajcej bd
   foreach($context as $name => $value)
   {
     if (!empty($value))
       $calls .= "\n  {$name} ma warto {$value}";
     else
       $calls .= "\n  {$name} ma warto NULL";
   }
   return ($calls);
}

function customHandler($number, $string, $file, $line, $context)
{
  $error = "";

  switch ($number)
  {
     case E_WARNING:
       $error .= "\nBd E_WARNING w wierszu {$line} w pliku {$file}.\n";
       break;
     case E_NOTICE:
       $error .= "\nBd E_NOTICE w wierszu {$line} w pliku {$file}.\n";
       break;
     default:
       $error .= "NIEOBSUONY BD w wierszu {$line} w pliku {$file}.\n";
  }
  $error .= "Bd: \"{$string}\" (bd numer {$number}).";
  $error .= backTrace($context);
  $error .= "\nAdres IP klienta: {$_SERVER["REMOTE_ADDR"]}";

  $prepend = "\n[Bd PHP " . date("YmdHis") . "]";
  $error = ereg_replace("\n", $prepend, $error);

  // Zwrcenie preformatowanego tekstu z informacjami o bdzie
  print "<pre>{$error}</pre>";
  // Zapisanie tekstu z informacjami o bdzie do pliku uytkownika
  // error_log($error, 3, "/home/daniel/log_bledow_php");

}

?>
