// Funkcja uytkowa zwracajca true, jeeli cig zawiera tylko 
// znaki odstpu.
function isblank(e)
{
  if (e.value == null || e.value == "")
    return true;

  for(var i = 0; i < e.value.length; i++)
  {
     var c = e.value.charAt(i);
     if ((c != ' ') &&
         (c != '\n') &&
         (c != '\t'))
        return false;
  }
  return true;
}

// Sprawdza, czy opcjonalne pole jest puste.
function checkblank(e)
{
  if (isblank(e))
  {
    alert("Pole " + e.description + " musi by wypenione.");
    return false;
  }
  return true;
}

// Sprawdza, czy pole jest numeryczne.
// Jeeli opcjonalna waciwo min jest ustawiona, sprawdza, czy warto pola jest 
// wiksza ni ta warto.
// Jeeli opcjonalna waciwo max jest ustawiona, sprawdza, czy warto pola jest 
// mniejsza ni ta warto.
function checknumber(e)
{
  var v = parseFloat(e.value);

  if (isNaN(v))
  {
    alert("Pole " + e.description + " musi zawiera liczb.");
    return false;
  }

  if ((e.minNumber != null) && (v < e.minNumber))
  {
    alert("Pole " + e.description +
          " musi zawiera liczb wiksz lub rwn od " + e.minNumber);
    return false;
  }

  if (e.maxNumber != null && v > e.maxNumber)
  {
    alert("Pole " + e.description +
          " musi zawiera liczb wiksz lub rwn od " + e.maxNumber);
    return false;
  }

  return true;
}

// Sprawdza, czy zawarto pola jest zapisana w formacie 99/99/9999
function checkdate(e)
{
  var slashCount = 0;
  if (e.value.length != 10)
  {
    alert(" Pole " + e.description +
          " musi mie format 99/99/9999" +
          " i mie dugo 10 znakw.");
    return false;
  }

  for(var j = 0; j < e.value.length; j++)
  {
    var c = e.value.charAt(j);

    if ((c == '/'))
       slashCount++;

    if (c != '/' && (c < '0' || c > '9'))
    {
      alert(" Pole " + e.description +
          " moe zawiera tylko liczby i ukoniki.");
      return false;
    }
  }

  if (slashCount != 2)
  {
    alert(" Pole " + e.description +
          " musi mie format 99/99/9999");
    return false;
  }

  return true;
}

// Sprawdza, czy pole zawiera jakikolwiek odstp.
function checkwhitespace(e)
{
  var seenAt = false;

  for(var j = 0; j < e.value.length; j++)
  {
     var c = e.value.charAt(j);

     if ((c == ' ') || (c == '\n') || (c == '\t'))
     {
       alert("Pole" + e.description +
             " nie moe zawiera odstpw.");
       return false;
     }
  }
  return true;
}

// Kontrola pl majcych zawiera adresy e-mail.
// Sprawdza, czy wystpuje jeden symbol @ i nie ma znakw odstpu.
function checkemail(e)
{
  var seenAt = false;

  for(var j = 0; j < e.value.length; j++)
  {
    var c = e.value.charAt(j);

    if ((c == ' ') || (c == '\n') || (c == '\t'))
    {
      alert("Pole " + e.description + 
            " nie moe zawiera odstpw.");
      return false;
    }

    if ((c == '@') && (seenAt == true))
    {
      alert("Pole " + e.description + " moe zawiera tylko jeden znak @.");
      return false;
    }

    if ((c == '@'))
      seenAt = true;
  }

  if (seenAt == false)
  {
    alert("Pole " + e.description + " musi zawiera jeden znak @.");
    return false;
  }
  return true;
}

// Funkcja wykonujca kontrol poprawnoci danych formularza.
// Jest wywoywana z procedury obsugi zdarzenia onSubmit().
// Procedura ta powinna zwrci warto zwracan przez t funkcj.
function verify(f)
{
  // Przegldanie elementw formularza i wyszukiwanie wszystkich elementw
  // text oraz textarea. Raportowanie bdw z wykorzystaniem opnionej
  // weryfikacji i wywietlania pole-po-polu.
  for(var i = 0; i < f.length; i++)
  {
     var e = f.elements[i];

     if (((e.type == "text") || (e.type == "textarea")))
     {
        // a pocztek sprawdzenia, czy pole jest puste, a nie powinno takie by.
        if (!e.isOptional && !checkblank(e))
          return false;

        // Sprawdzenie pl, ktre maj by numeryczne.
        if (!isblank(e) && e.isNumeric && !checknumber(e))
          return false;

        // Sprawdzenie pl, ktre powinny zawiera daty.
        if (!isblank(e) && e.isDate && !checkdate(e))
          return false;

        // Sprawdzenie pl, ktre powinny zawiera adresy e-mail.
        if (!isblank(e) && e.isEmail && !checkemail(e))
          return false;

        // Sprawdzenie pl, ktre nie powinny zawiera odstpw.
        if (!isblank(e) && e.hasNospaces && !checkwhitespace(e))
          return false;
     } 
  } 

  // Jeeli jestemy tutaj, to znaczy, e nie ma bdw.
  return true;
}

