<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Jest to skrypt pozwalajcy na wyszukiwanie i przegldanie win oraz 
// dodawanie win do koszyka na zakupy.

require_once "DB.php";
require_once "../includes/template.inc";
require_once "../includes/winestore.inc";

set_error_handler("customHandler");

// Tworzenie zapytania.
function setupQuery($region_name, $wine_type)
{
   // Pokazanie win znajdujcych si w magazynie winiarni, ktre
   // speniaj kryteria wyszukiwania.
   $query = "SELECT DISTINCT wi.winery_name, 
                     w.year, 
                     w.wine_name, 
                     w.wine_id
             FROM wine w, winery wi, inventory i, region r, wine_type wt
             WHERE w.winery_id = wi.winery_id
             AND w.wine_id = i.wine_id";

   // Dodanie ograniczenia na pole region_name jeeli zostaa wybrana pozycja inna 
   // ni "Wszystkie".
   if ($region_name != "Wszystkie")
      $query .= " AND r.region_name = '{$region_name}'
                  AND r.region_id = wi.region_id";
      
   // Dodanie ograniczenia na pole wine_type jeeli zostaa wybrana pozycja inna 
   // ni "Wszystkie".
   if ($wine_type != "Wszystkie")
      $query .= " AND wt.wine_type = '{$wine_type}'
                  AND wt.wine_type_id = w.wine_type";

   // Dodanie sposobu sortowania.
   $query .= " ORDER BY wi.winery_name, w.wine_name, w.year";

   return ($query);
}

// Pokazanie win zwrconych przez zapytanie.
function showWines($connection, &$template)
{
   // Dodanie nagwka na grze strony.
   $template->setCurrentBlock();
   $template->setVariable("SEARCHCRITERIA", 
              "Region: {$_SESSION["searchFormVars"]["region_name"]} " .
              "Rodzaj wina: {$_SESSION["searchFormVars"]["wine_type"]}");

   // Zakodowanie parametrw wyszukiwania w czach do innych stron wyniku.
   $browseString = "wine_type=" . 
                   urlencode($_SESSION["searchFormVars"]["wine_type"]) .  
                   "&amp;region_name=" . 
                   urlencode($_SESSION["searchFormVars"]["region_name"]);

   // Tworzenie zapytania z wykorzystaniem kryteriw wyszukiwania.
   $query = setupQuery($_SESSION["searchFormVars"]["region_name"], 
                       $_SESSION["searchFormVars"]["wine_type"]);

   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   $numRows = $result->numRows();

   // Czy zostay zwrcone dane?
   if ($numRows > 0)
   {
      // Tak, s dane.

      // Sprawdzenie sensownoci przesunicia, jeeli jest nieprawidowe, poprawka.

      // Przesunicie wiksze ni liczba wierszy? 
      // Ustawienie na liczb wierszy pomniejszon o SEARCH_ROWS.
      if ($_SESSION["searchFormVars"]["offset"] > $numRows)
        $_SESSION["searchFormVars"]["offset"] = $numRows - SEARCH_ROWS;

      // Przesunicie mniejsze ni zero? Ustawienie na zero.
      if ($_SESSION["searchFormVars"]["offset"] < 0)
        $_SESSION["searchFormVars"]["offset"] = 0;

      // Poprzednia strona zaczyna si od biecego przesunicia pomniejszonego
      // o liczb wierszy na stronie.
      $previousOffset = 
        $_SESSION["searchFormVars"]["offset"] - SEARCH_ROWS;

      // Nastpna strona zaczyna si od biecego przesunicia
      // powikszonego o liczb wierszy na stronie.
      $nextOffset = $_SESSION["searchFormVars"]["offset"] + SEARCH_ROWS;

      // Pobranie jednej strony wynikw (lub mniej na ostatniej stronie
      // rozpoczynajc od $_SESSION["searchFormVars"]["offset"])
      for ( $rowCounter = 0;
            $rowCounter < SEARCH_ROWS &&
            $rowCounter + $_SESSION["searchFormVars"]["offset"] < 
            $result->numRows() && 
            $row = $result->fetchRow(DB_FETCHMODE_ASSOC, 
                   $_SESSION["searchFormVars"]["offset"] + $rowCounter);
            $rowCounter++)
      {
         $template->setCurrentBlock("row");
         $template->setVariable("YEAR", $row["year"]);
         $template->setVariable("WINERY", $row["winery_name"]);
         $template->setVariable("WINE", $row["wine_name"]);
         $template->setVariable("VARIETIES", 
                    showVarieties($connection, $row["wine_id"]));

         $price = showPricing($connection, $row["wine_id"]);
         $template->setVariable("BOTTLE_PRICE", 
                                sprintf("%4.2f z", $price));
         $template->setVariable("DOZEN_PRICE", 
                                sprintf("%4.2f z", ($price*12)));

         $template->setVariable("ONEHREF", S_ADDTOCART . 
                                "?qty=1&amp;wineId={$row["wine_id"]}");
         $template->setVariable("DOZENHREF", S_ADDTOCART . 
                                "?qty=12&amp;wineId={$row["wine_id"]}");
         $template->parseCurrentBlock("row");
      } 

      // Pokazanie numeru ogldanego wiersza
      $template->setCurrentBlock();
      $template->setVariable("BEGINROW", 
                             $_SESSION["searchFormVars"]["offset"] + 1);
      $template->setVariable("ENDROW", $rowCounter + 
                             $_SESSION["searchFormVars"]["offset"]); 
      $template->setVariable("ROWS", $result->numRows());

      // Czy s strony wczeniejsze?
      if ($_SESSION["searchFormVars"]["offset"] >= SEARCH_ROWS)
      {
        // Jeeli tak, tworzenie cza do poprzedniej strony
         $template->setCurrentBlock("link");
         $template->setVariable("HREF", S_SEARCH . "?offset=" . 
                                rawurlencode($previousOffset) . 
                                "&amp;{$browseString}");
         $template->setVariable("HREFTEXT", "Poprzednia");
         $template->parseCurrentBlock("link");
      }
      else
      {
         // Nie, nie ma poprzednich stron, wic nie twrz cza
         $template->setCurrentBlock("outtext");
         $template->setVariable("OUTTEXT", "Poprzednia");
         $template->parseCurrentBlock("outtext");
      }

      $template->setCurrentBlock("links");
      $template->parseCurrentBlock("links");

      // Drukowanie numerw stron jako czy
      // Przegldanie numerw stron w wyniku.
      for($x=0, $page=1; $x<$result->numRows(); $x+=SEARCH_ROWS, $page++)
      {
         // Bieca strona?
         if ($x < $_SESSION["searchFormVars"]["offset"] || 
             $x > ($_SESSION["searchFormVars"]["offset"] + 
                   SEARCH_ROWS - 1))
         {
            // Nie, drukuj cze do tej strony
            $template->setCurrentBlock("link");
            $template->setVariable("HREF", 
              S_SEARCH . "?offset=" . rawurlencode($x) .
              "&amp;{$browseString}");
            $template->setVariable("HREFTEXT", $page);
            $template->parseCurrentBlock("link");
         }
         else
         {
            // Tak, nie drukuj cza.
            $template->setCurrentBlock("outtext");
            $template->setVariable("OUTTEXT", $page);
            $template->parseCurrentBlock("outtext");
         }

         $template->setCurrentBlock("links");
         $template->parseCurrentBlock("links");
      }

      // Czy istniej nastpne strony?
      if (isset($row) && ($result->numRows() > $nextOffset))
      {
         // Tak, utwrz cze do nastpnej strony.
         $template->setCurrentBlock("link");
         $template->setVariable("HREF", 
             S_SEARCH . "?offset=" . rawurlencode($nextOffset) .
             "&amp;{$browseString}");
         $template->setVariable("HREFTEXT", "Nastpna");
         $template->parseCurrentBlock("link");
      }
      else
      {
         // Nie, nie ma nastpnej strony, nie drukuj cza
         $template->setCurrentBlock("outtext");
         $template->setVariable("OUTTEXT", "Nastpna");
         $template->parseCurrentBlock("outtext");
      }

      $template->setCurrentBlock("links");
      $template->parseCurrentBlock("links");
   } // end if numRows()
   else
   {
      $template->setCurrentBlock("outtext");
      $template->setVariable("OUTTEXT", 
                             "Brak win speniajcych Twoje kryteria.");
      $template->parseCurrentBlock("outtext");
      $template->setCurrentBlock("links");
      $template->parseCurrentBlock("links");
   }
}


// ---------

session_start();    

$template = new winestoreTemplate(T_SEARCH);

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
   trigger_error($connection->getMessage(), E_USER_ERROR); 

// Zapamitanie parametrw wyszukiwania, aby formularz wywietla 
// poprzednie wyszukiwanie.
$_SESSION["searchFormVars"]["region_name"] = 
   pearclean($_GET, "region_name", 100, $connection);

$_SESSION["searchFormVars"]["wine_type"] = 
   pearclean($_GET, "wine_type", 32, $connection);

// Jeeli nie jest podane przesunicie, ustaw je na 0.
if (isset($_GET["offset"]))
   $_SESSION["searchFormVars"]["offset"] = 
     pearclean($_GET, "offset", 5, $connection);
else
   $_SESSION["searchFormVars"]["offset"] = 0;
   
// Uruchomienie wyszukiwania.
showWines($connection, $template);

$template->showWinestore(SHOW_ALL, B_HOME | B_SHOW_CART | B_SEARCH |
                         B_LOGINLOGOUT);
?>
