<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// skrypt ten pokazuje potwierdzenie zmian wprowadzonych do danych klienta
// Nie wykonuje zapisw w bazie danych i moe by dodany do
// zakadek przegldarki.
// Aby go zobaczy, uytkownik musi by zalogowany.

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";
require_once "../includes/template.inc";

set_error_handler("customHandler");

// Wywietlenie potwierdzenia operacji INSERT lub UPDATE na danych klienta.
function show_HTML_receipt($cust_id, $connection, &$template)
{
  // Odczyt danych klienta.
  $query = "SELECT * FROM customer WHERE cust_id = {$cust_id}";
  $result = $connection->query($query);
  if (DB::isError($result))
     trigger_error($result->getMessage(), E_USER_ERROR); 
  $row = $result->fetchRow(DB_FETCHMODE_ASSOC);

  // Czy dostpne jest opcjonalne pole telefonu? Jeeli tak, dodaj je do wyniku.
  if (!empty($row["phone"]))
  {
     $template->setCurrentBlock("phone");
     $template->setVariable("PHONE", $row["phone"]);
     $template->parseCurrentBlock("address");
  }

  // Dodaj do wyniku wszystkie pola obowizkowe.
  $template->setCurrentBlock();
  $template->setVariable("EMAIL", $_SESSION["loginUsername"]);
  $template->setVariable("FIRSTNAME", $row["firstname"]);
  $template->setVariable("SURNAME", $row["surname"]);
  $template->setVariable("INITIAL", $row["initial"]);
  $template->setVariable("ADDRESS", $row["address"]);
  $template->setVariable("CITY", $row["city"]);
  $template->setVariable("STATE", $row["state"]);
  $template->setVariable("ZIPCODE", $row["zipcode"]);
  $template->setVariable("DOB", $row["birth_date"]);
  $template->setVariable("CUSTTITLE", showTitle($row["title_id"],
                         $connection));
  $template->setVariable("COUNTRY", showCountry($row["country_id"],
                         $connection));
  
}

// -----

session_start();    

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
  trigger_error($connection->getMessage(), E_USER_ERROR); 

// Sprawdzenie, czy uytkownik jest poprawnie zalogowany.
sessionAuthenticate(S_MAIN);

// Wyszukanie wartoci cust_id dla uytkownika.
$cust_id = getCust_id($_SESSION["loginUsername"]);

// Rozpoczcie strony.
$template = new winestoreTemplate(T_CUSTRECEIPT);

// Pokazanie potwierdzenia.
show_HTML_receipt($cust_id, $connection, $template);

// Dodanie przyciskw, kolunikatw i wywietlenie strony
$template->showWinestore(NO_CART, B_HOME);
?>
