<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt zmienia iloci w koszyku.
// Oczekuje parametrw w postaci XXX=YYY
// gdzie XXX jest wartosci wine_id natomiast YYY jest now 
// iloci wina w koszyku.

require_once "DB.php";
require_once "../includes/winestore.inc";

set_error_handler("customHandler");

session_start();    

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
  trigger_error($connection->getMessage(), E_USER_ERROR); 

// Czyszczenie danych i zapisanywanie wynikw w tablicy.
foreach($_GET as $varname => $value)
   $parameters[$varname] = pearclean($_GET, $varname, 4, $connection);

// Czy na pewno chcesz zmieni iloci?
// Zabezpieczenie na wypadek przypadkowego wejcia do tego skryptu.
if (empty($parameters["update"]))
{
   $_SESSION["message"] = "Nieprawidowe parmaetry do " . S_UPDATECART;
   header("Location: " . S_SHOWCART);
   exit;
}      

// Jeeli uytkownik doda towar do koszyka, 
// bdzie zarejestrowana zmienna sesji order_no.

// Przegldanie przekazanych wartoci i modyfikacja koszyka.
foreach($parameters as $itemName => $itemValue)
{
   // Ignorowanie zmiennej update.
   if ($itemName != "update")
   {
      // Czy nazwa elementu wyglda jak wine_id?
      if (ereg("^[0-9]{1,4}$", $itemName))
      {
         // Czy warto na jak modyfikujemy jest liczb?
         if (ereg("^[0-9]{1,3}$", $itemValue))
         {
            // Jeeli liczba jest rwna 0, kasujemy element.
            if ($itemValue == 0)
               $query = "DELETE FROM items WHERE cust_id = -1
                         AND order_id = {$_SESSION["order_no"]}
                         AND item_id = {$itemName}";
            else
              // W przeciwnym razie zmieniamy warto.
              $query = "UPDATE items SET qty = {$itemValue}
                        WHERE cust_id = -1
                        AND order_id = {$_SESSION["order_no"]}
                        AND item_id = {$itemName}";
            $result = $connection->query($query);
            if (DB::isError($result))
               trigger_error($result->getMessage(), E_USER_ERROR); 

         } // if (ereg("^[0-9]{1,3}$", $itemValue))
         else
           $_SESSION["message"] = 
             "Ilo nie jest liczb lub niewaciwa dugo.";
      } // if (ereg("^[0-9]{1,4}$", $itemName))
      else
        $_SESSION["message"] = 
          "Identyfikator wina nie jest numeryczny lub ma niewaciw dugo.";
   } // if ($itemName != "update") 
} // foreach($parameters as $itemName => $itemValue)

// Koszyk moe by teraz pusty, sprawdmy to.
$query = "SELECT count(*) FROM items WHERE cust_id = -1
          AND order_id = {$_SESSION["order_no"]}";
          
$result = $connection->query($query);

if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR); 

$row = $result->fetchRow(DB_FETCHMODE_ASSOC);

// Nie ma ju adnych elementw?
if ($row["count(*)"] == 0)
{
   // Kasowanie zamwienia.
   $query = "DELETE FROM orders WHERE cust_id = -1
             AND order_id = {$_SESSION["order_no"]}";         
   $result = $connection->query($query);
   if (DB::isError($result))
      trigger_error($result->getMessage(), E_USER_ERROR); 

   unset($_SESSION["order_no"]);
}

// Powrt do koszyka.
header("Location: " . S_SHOWCART);
?>
