<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt pokazuje zawarto koszyka uytkownika.

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/template.inc";

set_error_handler("customHandler");

// Pokazuje zawarto koszyka uytkownika.
function displayCart($connection, &$template)
{
   // Jeeli uytkownik dodawa towary do koszyka, 
   // bdzie zarejestrowana zmienna order_no.
   if (isset($_SESSION["order_no"])) 
   {
      // Ustawienie akcji dla <form>
      $template->setVariable("S_UPDATECART", S_UPDATECART);

      // Wyszukanie towarw z koszyka.
      $cartQuery = "SELECT qty, price, wine_id, item_id 
                    FROM items WHERE cust_id = -1
                    AND order_id = {$_SESSION["order_no"]}";
      $result = $connection->query($cartQuery);
      if (DB::isError($result))
         trigger_error($result->getMessage(), E_USER_ERROR); 

      $cartAmount = 0;
      $cartCount = 0;

      // Dla kadego wina w koszyku:
      while ($row = $result->fetchRow(DB_FETCHMODE_ASSOC))
      {
         // Obliczenie liczby oraz wartosci towarw w koszyku.
         $cartCount += $row["qty"];
         $lineTotal = $row["price"] * $row["qty"];
         $cartAmount += $lineTotal;

         $template->setCurrentBlock("item");
         $template->setVariable("QUANTITY_NAME", $row["item_id"]);
         $template->setVariable("QUANTITY_VALUE", $row["qty"]);
         $template->setVariable("WINE", 
                                showWine($row["wine_id"], $connection));
         $template->setVariable("ITEM_PRICE", 
                                sprintf("%-.2f", $row["price"]));
         $template->setVariable("TOTAL_VALUE", 
                                sprintf("%-.2f", $lineTotal));
         $template->parseCurrentBlock("item");
      }
      $template->setCurrentBlock("cart");
      $template->setVariable("TOTAL_ITEMS", $cartCount);
      $template->setVariable("TOTAL_COST", sprintf("%-.2f", $cartAmount));
      $template->parseCurrentBlock("cart");
   } 
   else
   {
      // Uzytkownik nie woy nic do koszyka.
      $template->setCurrentBlock("emptycart");
      $template->setVariable("TEXT", "Koszyk jest pusty");
      $template->parseCurrentBlock("emptycart");
   }
}

session_start();

$template = new winestoreTemplate(T_SHOWCART);

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
  trigger_error($connection->getMessage(), E_USER_ERROR); 

// Wywietlenie zawartosci koszyka
displayCart($connection, $template);

$template->showWinestore(SHOW_ALL, B_ALL & ~B_SHOW_CART & 
                         ~B_PASSWORD & ~B_DETAILS);
?>
