<?php
// Source code example for Web Database Applications with PHP and MySQL, 2nd Edition
// Author: Hugh E. Williams, 2001-3
// 
// Unless otherwise stated, the source code distributed with this book can be
// redistributed in source or binary form so long as an acknowledgment appears
// in derived source files.
// The citation should list that the code comes from Hugh E. Williams and David 
// Lane, "Web Database Application with PHP and MySQL" published by O'Reilly & 
// Associates.
//
// This code is under copyright and cannot be included in any other book,
// publication, or educational product without permission from O'Reilly &
// Associates. No warranty is attached; we cannot take responsibility for errors 
// or fitness for use.

// Skrypt kontroluje dane karty kredytowej i zapisuje prawidowe dane.

require_once "DB.php";
require_once "../includes/winestore.inc";
require_once "../includes/authenticate.inc";
require_once "../includes/validate.inc";

set_error_handler("customHandler");

session_start();

// Podczenie do autoryzowanej sesji.
sessionAuthenticate(S_SHOWCART);

// Sprawdzenie, czy koszyk nie jest pusty.
if (!isset($_SESSION["order_no"]))
{
   $_SESSION["message"] = "Koszyk jest pusty!";

   header("Location: " . S_SHOWCART);
   exit;
}   

$connection = DB::connect($dsn, true);
if (DB::isError($connection))
   trigger_error($connection->getMessage(), E_USER_ERROR); 

// Rejestracja tabeli na bdy - na wszelki wypadek!
$_SESSION["ccErrors"] = array();

// Tworzenie tablicy formVars na zmienne POST.
$_SESSION["ccFormVars"] = array();

foreach($_POST as $varname => $value)
   $_SESSION["ccFormVars"]["{$varname}"] = 
     pearclean($_POST, $varname, 128, $connection);

// Sprawdzenie, czy zosta podany nymer karty kredytowej.
if (checkMandatory("creditcard", "SurchargeCard", 
              "ccErrors", "ccFormVars"))
   // Kontrola poprawnoci numeru za pomoc algorytmu Luhna.
   checkCard("creditcard", "ccErrors", "ccFormVars");

// Sprawdzenie, czy zostaa podana obowizkowa data wanoci karty.
if (checkMandatory("expirydate", "expiry date", 
              "ccErrors", "ccFormVars"))
   // Kontrola poprawnoci daty wanoci.
   checkExpiry("expirydate", "ccErrors", "ccFormVars");

// Skrypt zakoczy kontrol poprawnoci, 
// sprawdzenie, czy wystpiy bdy.
if (count($_SESSION["ccErrors"]) > 0)
{
    // Wystpiy bdy. Powrt do punktu 1.
    header("Location: " . S_ORDER_1);
    exit;
}

// Mona modyfikowa zamwienie.
$query = "UPDATE orders SET 
          creditcard = '{$_SESSION["ccFormVars"]["creditcard"]}',
          expirydate = '{$_SESSION["ccFormVars"]["expirydate"]}',
          instructions = '{$_SESSION["ccFormVars"]["instructions"]}'
          WHERE cust_id = -1 AND
                order_id = {$_SESSION["order_no"]}";

$result = $connection->query($query);

if (DB::isError($result))
   trigger_error($result->getMessage(), E_USER_ERROR); 

// Kasowanie zawartoci formVars, aby formularz by pusty.
unset($_SESSION["ccFormVars"]);
unset($_SESSION["ccErrors"]);

// Przejcie do przetwarzania zamwienia.
header("Location: " . S_ORDER_3);
?>
