<?php include_once $_SERVER['DOCUMENT_ROOT'] .
    '/includes/helpers.inc.php'; ?>
<!DOCTYPE html>
<html lang="pl">
  <head>
    <meta charset="utf-8">
    <title>Koszyk zakupów</title>
    <style>
    table {
      border-collapse: collapse;
    }
    td, th {
      border: 1px solid black;
    }
    </style>
  </head>
  <body>
    <h1>Zawartość koszyka</h1>
    <?php if (count($cart) > 0): ?>
    <table>
      <thead>
        <tr>
          <th>Opis produktu</th>
          <th>Cena</th>
        </tr>
      </thead>
      <tfoot>
        <tr>
          <td>Kwota do zapłaty:</td>
          <td><?php echo number_format($total, 2, ",", "."); ?> BTC</td>
        </tr>
      </tfoot>
      <tbody>
        <?php foreach ($cart as $item): ?>
          <tr>
            <td><?php htmlout($item['desc']); ?></td>
            <td>
              <?php echo number_format($item['price'], 2, ",", "."); ?> BTC
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
    <?php else: ?>
    <p>Koszyk jest pusty!</p>
    <?php endif; ?>
    <form action="?" method="post">
      <p>
        <a href="?">Wróć do katalogu</a> lub
        <input type="submit" name="action" value="Opróżnij koszyk">
      </p>
    </form>
  </body>
</html>
