<?php include_once $_SERVER['DOCUMENT_ROOT'] .
    '/includes/helpers.inc.php'; ?>
<!DOCTYPE html>
<html lang="pl">
  <head>
    <meta charset="utf-8">
    <title>Repozytorium plików oparte na PHP i MySQL-u</title>
  </head>
  <body>
    <h1>Repozytorium plików oparte na PHP i MySQL-u</h1>

    <form action="" method="post" enctype="multipart/form-data">
      <div>
        <label for="upload">Przesyłanie pliku:
        <input type="file" id="upload" name="upload"></label>
      </div>
      <div>
        <label for="desc">Opis pliku:
        <input type="text" id="desc" name="desc"
            maxlength="255"></label>
      </div>
      <div>
        <input type="hidden" name="action" value="upload">
        <input type="submit" value="Prześlij">
      </div>
    </form>

    <?php if (count($files) > 0): ?>

    <p>W bazie zapisane są następujące pliki:</p>

    <table>
      <thead>
        <tr>
          <th>Nazwa pliku</th>
          <th>Typ</th>
          <th>Opis</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($files as $f): ?>
        <tr>
          <td>
            <a href="?action=view&amp;id=<?php htmlout($f['id']); ?>"
                ><?php htmlout($f['filename']); ?></a>
          </td>
          <td><?php htmlout($f['mimetype']); ?></td>
          <td><?php htmlout($f['description']); ?></td>
          <td>
            <form action="" method="get">
              <div>
                <input type="hidden" name="action" value="download"/>
                <input type="hidden" name="id" value="<?php htmlout($f['id']); ?>"/>
                <input type="submit" value="Pobierz"/>
              </div>
            </form>
          </td>
          <td>
            <form action="" method="post">
              <div>
                <input type="hidden" name="action" value="delete"/>
                <input type="hidden" name="id" value="<?php htmlout($f['id']); ?>"/>
                <input type="submit" value="Usuń"/>
              </div>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>

    <?php endif; ?>
  </body>
</html>
