CREATE TABLE joke (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	joketext TEXT,
	jokedate DATE NOT NULL,
	authorid INT
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE author (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(255),
	email VARCHAR(255)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE category (
	id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
	name VARCHAR(255)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

CREATE TABLE jokecategory (
	jokeid INT NOT NULL,
	categoryid INT NOT NULL,
	PRIMARY KEY (jokeid, categoryid)
) DEFAULT CHARACTER SET utf8 ENGINE=InnoDB;

# Przykładowe dane
# Określamy 'id', aby było zgodne w odwołaniach z innych tabel

INSERT INTO author (id, name, email) VALUES
(1, 'Kevin Yank', 'thatguy@kevinyank.com'),
(2, 'Jan Kowalski', 'jan@przyklad.com');

INSERT INTO joke (id, joketext, jokedate, authorid) VALUES
(1, 'Dlaczego kura przeszła przez szosę? Żeby dostać się na drugą stronę.', '2012-04-01', 1),
(2, 'Ile zajmuje Windows 7? Ile znajdzie, tyle zajmie...', '2012-04-01', 1),
(3, 'Kupiłem synowi kamerę internetową. Jedną stronę pokoju ma teraz posprzątaną...', '2012-04-01', 2),
(4, 'Ilu wegan potrzeba, żeby zmienić żarówkę? Dwóch. Jeden wkręca, drugi czyta skład.', '2012-04-01', 2);

INSERT INTO category (id, name) VALUES
(1, 'Przechodzenie przez szosę'),
(2, 'Żarówki'),
(3, 'Rodzinne'),
(4, 'Wegetarianie'),
(5, 'Komputerowe');

INSERT INTO jokecategory (jokeid, categoryid) VALUES
(1, 1), (2, 5), (3, 4), (4, 3), (4, 5), (3, 2);
