<?php
session_start();
$timeout = 5;
include "portal.php";

$portal = new Portal();
try{
  $portal->initDB("localhost", "php", "test", "testphp");
}
catch(Exception $e){
  //echo 'Brak połączenia z bazą danych.';
  //exit();
}
if(!isset($_SESSION['statRecordId']) && 
   !isset($_SESSION['zalogowany'])){  
  $_SESSION['statRecordId'] = $portal->addStatRecord(0);
}
?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<link rel="stylesheet" type="text/css" href="style.css">
<title>Portal</title>
</head>
<body>
<div id="topDiv">
<div id="headerMainDiv">
<a href="index.php">Główna</a> |
<a href="index.php?action=showNewsList">Lista nowości</a>
</div>
<div id="headerUserInfoDiv">
<?php echo $portal->getUserInfo(); ?>
</div>
<div id="mainContentDiv">
<?php
if (isset($_GET['action'])) {
  $action = $_GET['action'];
}
else{
  $action = 'showMain';
}
switch($action):
  case 'showLoginForm' :
    include 'loginForm.php';
    break;
  case 'showFullStats' :
    echo $portal->getFullStats();
    include 'statsForm.php';
    break;
  case 'showNewsList':
    echo $portal->getNewsList(ROWS_ON_PAGE);
    break;
  case 'showNews' :
    echo $portal->getNews();
    break;
  case 'showMain':
  default:
?>
<div style='width:200px;height:100px;margin-top:150px;margin-left:auto;margin-right:auto;'>
To jest część główna portalu. To jest część główna portalu.
To jest część główna portalu. To jest część główna portalu.
</div>
<?php
endswitch;
?>
</div>
<div id="rightSideDiv">
<div style='font-weight:bold;'>Nowości</div>
<?php echo $portal->getNewsHeaders(5); ?>
</div>
<div id="footerDiv">
<?php echo $portal->getShortStats($timeout); ?>
<?php echo "<br />Zobacz pozostałe <a href=\"index.php?action=" .
           "showFullStats\">statystyki</a>."; ?>
</div>
</div>
</body>
</html>
