<?php

declare(strict_types=1);

/*
 * Włącz sesje w razie potrzeby
 * (pozwala uniknąć niechcianego ostrzeżenia, jeżeli sesja jest już aktywna).
 */
$status = session_status();
if ($status == PHP_SESSION_NONE){
    // Brak aktywnej sesji
    session_start();
}

/*
 * Wygeneruj token zabezpieczający przed CSRF, o ile nie istnieje
 */
if ( !isset($_SESSION['token']) )
{
    $_SESSION['token'] = sha1(uniqid((string)mt_rand(), TRUE));
}

/*
 * Załaduj niezbędne ustawienia konfiguracyjne
 */
include_once '../sys/config/db-cred.inc.php';

/*
 * Zdefiniuj stałe konfiguracyjne
 */
foreach ( $C as $name => $val )
{
    define($name, $val);
}

/*
 * Utwórz obiekt PDO
 */
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
$dbo = new PDO($dsn, DB_USER, DB_PASS);
$dbo->query("SET NAMES 'utf8'");

/*
 * Mechanizm automatycznego ładowania klas
 */
function __autoload($class)
{
    $filename = "../sys/class/class." . $class . ".inc.php";
    //echo "INFO: init.inc.php: autoload: " . $filename . "<br />";
    if ( file_exists($filename) )
    {
        include_once $filename;
    }
}

?>