<?php

declare(strict_types=1);

/**
 * Operacje związane z bazą danych (dostęp, sprawdzanie poprawności, itp.)
 *
 * PHP w wersji 7
 *
 * LICENCJA: Plik źródłowy udostępniany na licencji MIT opisanej pod adresem
 * http://www.opensource.org/licenses/mit-license.html
 *
 * @author Jason Lengstorf <jason.lengstorf@ennuidesign.com>
 * @copyright 2009 Ennui Design
 * @license http://www.opensource.org/licenses/mit-license.html
 */
class DB_Connect {

    /**
     * Przechowuje obiekt bazy danych
     *
     * @var object obiekt bazy danych
     */
    protected $db;

    /**
     * Sprawdza, czy obiekt bazy danych istnieje, a jeśli nie - tworzy nowy
     *
     * @param object $db Obiekt bazy danych
     */
    protected function __construct($db=NULL)
    {
        if ( is_object($db) )
        {
            $this->db = $db;
        }
        else
        {
            // Stałe zdefiniowano w pliku /sys/config/db-cred.inc.php
            $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
            try
            {
                $this->db = new PDO($dsn, DB_USER, DB_PASS);
                $this->db->query("SET NAMES 'utf8'");
            }
            catch ( Exception $e )
            {
                // Jeśli nie uda się połączyć z bazą, wyświetl komunikat o błędzie
                die ( $e->getMessage() );
            }
        }
    }

}

?>