<?php

declare(strict_types=1);

/*
 * Włącz sesje
 */
session_start();

/*
 * Załaduj niezbędne pliki
 */
include_once '../../../sys/config/db-cred.inc.php';

/*
 * Zdefiniuj stałe z pliku konfiguracyjnego
 */
foreach ( $C as $name => $val )
{
    define($name, $val);
}

/*
 * Utwórz tablicę dopuszczalnych wartości parametru action
 */
define('ACTIONS', array(
        'event_edit' => array(
                'object' => 'Calendar',
                'method' => 'processForm',
                'header' => 'Location: ../../'
            )
        )
    );

/*
 * Potrzebny obiekt PDO.
 */
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME;
$dbo = new PDO($dsn, DB_USER, DB_PASS);
$dbo->query("SET NAMES 'utf8'");

/*
 * Upewnij się, że wysłano token zabezpieczający przed atakiem typu CSRF i że
 * wartość parametru action żądania istnieje w zdefiniowanej wcześniej tablicy
 */
if ( $_POST['token']==$_SESSION['token']
        && isset(ACTIONS[$_POST['action']]) )
{
    $use_array = ACTIONS[$_POST['action']];
    $obj = new $use_array['object']($dbo);
    $method = $use_array['method'];
    if ( TRUE === $msg=$obj->$method() )
    {
        header($use_array['header']);
        exit;
    }
    else
    {
        // Jeżeli wystąpił błąd, wyświetl go i zakończ działanie
        die ( $msg );
    }
}
else
{
    // Przekieruj do pliku index.php, jeżeli token lub parametr action są nieprawidłowe
    header("Location: ../../");
    exit;
}

function __autoload($class_name)
{
    $filename = '../../../sys/class/class.'
        . strtolower($class_name) . '.inc.php';
    //echo "INFO: process.inc.php: autoload: " . $filename . "<br />";
    if ( file_exists($filename) )
    {
        include_once $filename;
    }
}

?>