"use strict";

// Upewnij się, że dokument jest gotowy przed wykonaniem skryptów
jQuery(function($){

// Szybkie sprawdzenie, czy skrypt został poprawnie załadowany
console.log("Plik init.js został pomyślnie załadowany.");

// Plik, do którego mają być kierowane żądania AJAX
var processFile = "assets/inc/ajax.inc.php",

// Funkcje operujące na oknie modalnym
    fx = {

        // Sprawdza istnienie okna modalnego i zwraca jego kod lub
        // tworzy i zwraca nowe
        "initModal" : function() {
                // Jeżeli nie dopasowano elementu, właściwość length
                // będzie miała wartość 0
                if ( $(".modal-window").length==0 )
                {
                    // Utwórz element div, dodaj do niego klasę i
                    // umieść go wewnątrz elementu body
                    return $("<div>")
                            .hide()
                            .addClass("modal-window")
                            .appendTo("body");
                }
                else
                {
                    // Zwraca okno modalne, jeżeli istnieje
                    // w drzewie DOM
                    return $(".modal-window");
                }
            },

        // Wstawia okno do kodu HTML i płynnie je wyświetla
        "boxin" : function(data, modal) {
                // Utwórz warstwę maskującą treść strony, dodaj do niej
                // klasę i procedurę obsługi zdarzenia click, a następnie
                // umieść ją w elemencie body
                $("<div>")
                    .hide()
                    .addClass("modal-overlay")
                    .click(function(event){
                            // Usuń wydarzenie
                            fx.boxout(event);
                        })
                    .appendTo("body");

                // Wczytaj dane do okna modalnego i
                // umieść je w elemencie body
                modal
                    .hide()
                    .append(data)
                    .appendTo("body");

                // Pokaż płynnie okno i warstwę maskującą
                $(".modal-window,.modal-overlay")
                    .fadeIn("slow");
            },

        // Ukrywa płynnie okno i usuwa je z DOM
        "boxout" : function(event) {
                // Jeżeli element wywołujący tę funkcję
                // wyzwolił zdarzenie,
                // wstrzymaj domyślne działanie
                if ( event!=undefined )
                {
                    event.preventDefault();
                }

                // Usuń klasę active ze wszystkich odnośników
                $("a").removeClass("active");

                // Wygaś okno modalne i warstwę maskującą,
                // a następnie usuń oba elementy z DOM
                $(".modal-window,.modal-overlay")
                    .fadeOut("slow", function() {
                            $(this).remove();
                        }
                    );
            },

        // Dodaje nowe wydarzenie po jego zapisaniu do kodu HTML
        "addevent" : function(data, formData){
                // Przekształć łańcuch zapytania w obiekt
                var entry = fx.deserialize(formData),

                // Utwórz obiekt daty dla bieżącego miesiąca
                cal = new Date(NaN),

                // Utwórz obiekt daty dla nowego wydarzenia
                event = new Date(NaN),

                // Wyodrębnij miesiąc i rok z identyfikatora elementu h2
                cdata = $("h2").attr("id").split('-'),

                // Wyodrębnij dzień, miesiąc i rok wydarzenia
                date = entry.event_start.split(' ')[0],

                // Podziel datę wydarzenia
                edata = date.split('-');

                // Ustaw datę w obiekcie kalendarza
                cal.setUTCFullYear(cdata[1], cdata[2], 1);

                // Ustaw datę w obiekcie wydarzenia
                event.setUTCFullYear(edata[0], edata[1], edata[2]);

                // Ponieważ obiekt daty jest tworzony na podstawie
                // czasu uniwersalnego, a następnie dostosowywany do strefy czasowej użytkownika,
                // dodaj lub odejmij określoną liczbę minut, aby uzyskać właściwą datę
                event.setMinutes(event.getTimezoneOffset());

                // Jeżeli rok i miesiąc się zgadzają, rozpocznij proces
                // dodawania nowego wydarzenia do kalendarza
                if ( cal.getFullYear()==event.getFullYear() && cal.getMonth()==event.getMonth() )
                {
                    // Pobierz dzień miesiąca wydarzenia
                    var day = String(event.getDate());

                    // Poprzedź jednocyfrowe dni zerem
                    day = day.length==1 ? "0"+day : day;

                    // Dodaj nowy odnośnik
                    $("<a>")
                        .hide()
                        .attr("href", "view.php?event_id="+data)
                        .text(entry.event_title)
                         .insertAfter($("strong:contains("+day+")"))
                        .delay(1000)
                        .fadeIn("slow");
                }
            },

        // Usuń wydarzenie z kodu HTML 
        "removeevent" : function()
        {
                // Usuń każde wydarzenie z klasą "active" 
                $(".active")
                    .fadeOut("slow", function(){
                            $(this).remove();
                        });
            },


        // Przeprowadza deserializację łańcucha zapytania i zwraca
        // obiekt wydarzenia
        "deserialize" : function(str){
                // Rozbij parę nazwa-wartość
                var data = str.split("&"),

                // Deklaruj zmienne potrzebne w pętli
                pairs=[], entry={}, key, val;

                // Przekształć każdą parę nazwa-wartość we właściwość obiektu
                for (var x in data )
                {
                    // Rozdziel każdą parę i zapisz otrzymane elementy w tablicy
                    pairs = data[x].split("=");

                    // Pierwszy element to nazwa parametru
                    key = pairs[0];

                    // Drugi element to wartość paramentru
                    val = pairs[1];

                    // Przywróć łańcuchowi zakodowanemu w URL oryginalną postać
                    // i zapisz każdą wartość jako właściwość obiektu
                    entry[key] = fx.urldecode(val);
                }
                return entry;
            },

        // Dekoduje łańcuch zapytania
        "urldecode" : function(str) {
                // Zamienia znaki plus na spacje
                var converted = str.replace(/\+/g, ' ');

                // Zamienia encje na odpowiadające im znaki
                return decodeURIComponent(converted);
            }
    
    };

// Wyświetl wydarzenie w oknie modalnym
$("body").on("click", "li>a", function(event){

        // Zapobiega załadowaniu pliku view.php
        event.preventDefault();

        // Dodaj klasę "active" do odnośnika
        $(this).addClass("active");

        // Pobierz łańcuch zapytania z atrybutu href odnośnika
        var data = $(this)
                        .attr("href")
                        .replace(/.+?\?(.*)$/, "$1");

        // Wyświetl w konsoli łańcuch zapytania
        console.log( data );

        // Sprawdź czy okno modalne istnieje i
        // wybierz je lub utwórz nowe
        var modal = fx.initModal();

        // Utwórz przycisk do zamykania okna
        $("<a>")
            .attr("href", "#")
            .addClass("modal-close-btn")
            .html("&times;")
            .click(function(event){
                        // Usuń okno modalne
                        fx.boxout(event);
                    })
            .appendTo(modal);

        // Pobierz informacje o wydarzeniach z bazy danych
        $.ajax({
                type: "POST",
                url: processFile,
                data: "action=event_view&" + data,
                success: function(data){
                        fx.boxin(data, modal);
                    },
                error: function(msg) {
                        modal.append(msg);
                    }
            });

    });

// Wyświetl w oknie modalnym formularz edycji
$("body").on("click", ".admin-options form,.admin", function(event){

        // Zapobiega wysłaniu formularza
        event.preventDefault();

        // Ustaw wartość parametru action
        var action = $(event.target).attr("name") || "edit_event",

        // Zapisz wartość elementu input o nazwie event_id
        id = $(event.target)
            .siblings("input[name=event_id]")
            .val();

        // Utwórz dodatkowy parametr z identyfikatorem, o ile został określony
        id = ( id!=undefined ) ? "&event_id="+id : "";

        // Ładuj i wyświetl formularz edycji
        $.ajax({
                type: "POST",
                url: processFile,
                data: "action="+action+id,
                success: function(data){
                        // Ukryj formularz
                        var form = $(data).hide(),

                        // Sprawdź, czy okno modalne istnieje
                        modal = fx.initModal()
                            .children(":not(.modal-close-btn)")
                                .remove()
                                .end();

                        // Wywołaj funkcję boxin, aby utworzyć
                        // i wyświetlić warstwę maskującą
                        fx.boxin(null, modal);

                        // Załaduj formularz do okna,
                        // pokaż jego zawartość i dodaj
                        // klasę
                        form
                            .appendTo(modal)
                            .addClass("edit-form")
                            .fadeIn("slow");
                },
                error: function(msg){
                   alert(msg);
                }
            });
   });

// Przycisk Anuluj w formularzu edycji działa tak, jak
// przycisk Zamknij - ukrywa okno modalne i warstwę maskującą
$("body").on("click", ".edit-form a:contains(anuluj)", function(event){
      fx.boxout(event);
   });

// Edytuj wydarzenia bez konieczności przeładowywania strony
$("body").on("click", ".edit-form input[type=submit]", function(event){

        // Anuluj domyślne działanie
        event.preventDefault();

        // Zwróć uwagę na nazwę wydarzenia, jeżeli jest edytowane 
        if ( $(this).attr("name")=="event_submit" && $(".active").length > 0 )
        {
            // Trzeba sprawdzić, czy nazwa wydarzenia została zmieniona. 
            // Oto nazwa wyświetlana w kalendarzu. 
            var oldTitle = $(".active")[0].innerHTML;
             
            // Tu natomiast wyodrębniamy nazwę z danych formularza. 
            var formArray = $(this).parents("form").serializeArray();
            var titleArray = $.grep(formArray, function(elem) {
                return elem.name === 'event_title';
            });
            var newTitle = titleArray.length > 0 ? titleArray[0].value : "";
             
            if (newTitle !== oldTitle)
            {
                // Nazwa wydarzenia została zmieniona - aktualizuj stronę. 
                $(".active")[0].innerHTML = newTitle;
            }
        }


        // Serializuj dane z formularza wykorzystywane w wywołaniu funkcji $.ajax()
        var formData = $(this).parents("form").serialize(),

        // Zapisz wartość przycisku submit 
        submitVal = $(this).val(),

        // Określa, czy trzeba usunąć wydarzenie 
        remove = false;

        // Jeżeli wysyłany jest formularz do usuwania wydarzeń, dołącz parametry 
        if ( $(this).attr("name")=="confirm_delete" )
        {
            // Dodaj do łańcucha zapytania niezbędne informacje 
            formData += "&action=confirm_delete" + "&confirm_delete="+submitVal;

            // Jeśli potwierdzono usunięcie wydarzenia, ustaw 
            // wartość zmiennej, aby usunąć je z kodu HTML 
            if ( submitVal=="Tak, usuń wydarzenie" )
            {
                remove = true;
            }
        }

        // Wyślij dane do pliku obsługującego żądania
        $.ajax({
                type: "POST",
                url: processFile,
                data: formData,
                success: function(data) {
                    // Jeśli potwierdzono usunięcie wydarzenia, usuń 
                    // je z kodu HTML 
                    if ( remove===true )
                    {
                        fx.removeevent();
                    }

                    // Ukryj okno modalne
                    fx.boxout();

                    // Jeżeli tworzone jest nowe wydarzenie, dodaj je do 
                    // kalendarza 
                    if ( $("[name=event_id]").val().length==0 && remove===false )
                    {
                        fx.addevent(data, formData);
                    }
                },
                error: function(msg) {
                    alert(msg);
                }
            });
    });
});