<?php

declare(strict_types=1);

/**
 * Przechowuje informacje o wydarzeniu
 * 
 * PHP w wersji 7
 *
 * LICENCJA: Plik źródłowy udostępniany na licencji MIT opisanej pod adresem
 * http://www.opensource.org/licenses/mit-license.html
 *
 * @author Jason Lengstorf <jason.lengstorf@ennuidesign.com>
 * @copyright 2010 Ennui Design
 * @license http://www.opensource.org/licenses/mit-license.html
 */
class Event
{

    /**
     * Identyfikator wydarzenia
     *
     * @var int
     */
    public $id;

    /**
     * Nazwa wydarzenia
     *
     * @var string
     */
    public $title;

    /**
     * Opis wydarzenia
     *
     * @var string
     */
    public $description;

    /**
     * Czas rozpoczęcia wydarzenia
     *
     * @var string
     */
    public $start;

    /**
     * Czas zakończenia wydarzenia
     *
     * @var string
     */
    public $end;

    /**
     * Przyjmuje jako argument dane o wydarzeniach w postaci tablicy i zapisuje je
     *
     * @param array $event Tablica asocjacyjna z danymi o wydarzeniach
     * @return void
     */
    public function __construct($event)
    {
        if ( is_array($event) )
        {
            $this->id = $event['event_id'];
            $this->title = $event['event_title'];
            $this->description = $event['event_desc'];
            $this->start = $event['event_start'];
            $this->end = $event['event_end'];
        }
        else
        {
            throw new Exception("Brak danych wydarzenia.");
        }
    }

}

?>