<?php

declare(strict_types=1);

/*
 * Włącz sesje w razie potrzeby
 * (pozwala uniknąć niechcianego ostrzeżenia, jeżeli sesja jest już aktywna).
 */
$status = session_status();
if ($status == PHP_SESSION_NONE){
    // Brak aktywnej sesji
    session_start();
}

/*
 * Upewnij się, że został przekazany identyfikator wydarzenia, a użytkownik jest zalogowany
 */
if ( isset($_POST['event_id']) && isset($_SESSION['user']) )
{
    /*
     * Odczytaj identyfikator wydarzenia z łańcucha URL
     */
    $id = (int) $_POST['event_id'];
}
else
{
    /*
     * W przypadku braku identyfikatora lub, jeśli użytkownik nie jest zalogowany
     * przekieruj go do strony głównej
     */
    header("Location: ./");
    exit;
}

/*
 * Załaduj niezbędne pliki
 */
include_once '../sys/core/init.inc.php';

/*
 * Ładuj kalendarz
 */
$cal = new Calendar($dbo);
$markup = $cal->confirmDelete($id);

/*
 * Wyświetl nagłówek
 */
$page_title = "Zobacz wydarzenie";
$css_files = array("style.css", "admin.css");
include_once 'assets/common/header.inc.php';

?>

<div id="content">
<?php echo $markup; ?>

</div><!-- end #content -->

<?php

/*
 * Wyświetl stopkę
 */
include_once 'assets/common/footer.inc.php';

?>