<?php # Skrypt 17.5 - browse_prints.php
// Ta strona wywietla dostpne odbitki (produkty).

// Konfiguruje tytu strony i docza nagwek HTML.
$page_title = 'Przegldanie odbitek';
include ('includes/header.html');

require_once ('../mysqli_connect.php');
 
// Domylne zapytanie dla tej strony.
$q = "SELECT artists.artist_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS artist, print_name, price, description, print_id FROM artists, prints WHERE artists.artist_id = prints.artist_id ORDER BY artists.last_name ASC, prints.print_name ASC";

// Czy szuka konkretnego artysty?
if (isset($_GET['aid']) && is_numeric($_GET['aid']) ) {
	$aid = (int) $_GET['aid'];
	if ($aid > 0) { // Zmienia zapytanie.
		$q = "SELECT artists.artist_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS artist, print_name, price, description, print_id FROM artists, prints WHERE artists.artist_id = prints.artist_id AND prints.artist_id = $aid ORDER BY prints.print_name";
	}
}

// Tworzy nagwek tabeli.
echo '<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
	<tr>
		<td align="left" width="20%"><b>Artysta</b></td>
		<td align="left" width="20%"><b>Nazwa odbitki</b></td>
		<td align="left" width="40%"><b>Opis</b></td>
		<td align="right" width="20%"><b>Cena</b></td>
	</tr>';

// Wywietla wszystkie odbitki wraz z czami URL.
$r = mysqli_query ($dbc, $q);
while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {

	// Wywietla kady rekord.
	echo "\t<tr>
		<td align=\"left\"><a href=\"browse_prints.php?aid={$row['artist_id']}\">{$row['artist']}</a></td>
		<td align=\"left\"><a href=\"view_print.php?pid={$row['print_id']}\">{$row['print_name']}</td>
		<td align=\"left\">{$row['description']}</td>
		<td align=\"right\">\${$row['price']}</td>
	</tr>\n";

} // Koniec ptli while.

echo '</table>';
mysqli_close($dbc);
include ('includes/footer.html');
?>
