<?php # Skrypt 16.3 - config.inc.php
/* Ten skrypt:
 * - definiuje stae i konfiguracj witryny
 * - okrela sposb obsugi bdw
 * - definiuje funkcje uywane przez witryn
 */
 
// Tutaj udokumentuj kto, kiedy i w jakim celu stworzy t witryn.


// ********************************** //
// ************ SETTINGS ************ //

// Znacznik statusu witryny.
define('LIVE', FALSE);

// Adres administratora.
define('EMAIL', 'InsertRealAddressHere');

// Adres URL witryny (do przekierowa).
define ('BASE_URL', 'http://www.example.com/');

// Pooenie skryptu nawizujcego poczenie z serwerem MySQL.
define ('MYSQL', '/path/to/mysqli_connect.php');

// Skonfiguruj stref czasow (dla PHP 5.1 i nowszych):
date_default_timezone_set ('Europe/Warsaw');

// ************ KONFIGURACJA ************ //
// ********************************** //


// ****************************************** //
// ************ ZARZDZANIE BDAMI ************ //

// Procedura obsugi bdw.
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

	// Komunikat o bdzie.
	$message = "<p>W $e_line. wierszu skryptu '$e_file' wystpi bd: $e_message\n<br />";
	
	// Dodaje informacje o dacie i czasie.
	$message .= "Data/Czas: " . date('n-j-Y H:i:s') . "\n<br />";
	
	// Docza $e_vars do $message:
	$message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n</p>";
	
	if (!LIVE) { // Faza uruchomieniowa (wywietla bd).
	
		echo '<div class="error">' . $message . '</div><br />';
		
	} else { // Nie wywietla informacji o bdzie.
	
		// Wysya wiadomo e-mail do administratora.
		mail(EMAIL, 'Bd witryny!', $message, 'From: email@example.com');
		
		// Wywietla komunikat o bdzie tylko gdy bd nie naley do klasy E_NOTICE.
		if ($e_number != E_NOTICE) {
			echo '<div class="error">Wystpi bd systemu. Przepraszamy za niedogodno.</div><br />';
		}
	} // Koniec instrukcji if !LIVE.

} // Koniec definicji funkcji my_error_handler() .

// Konfiguruje procedur obsugi bdw.
set_error_handler ('my_error_handler');

// ************ ZARZDZANIE BDAMI ************ //
// ****************************************** //

?>
