<?php # Skrypt 15.7 - post.php
// Obsuguje wstawianie wiadomoci.
// Wywietla rwnie formularz, gdy tworzony jest nowy wtek.
include ('includes/naglowek.html');


if (isset($_POST['submitted'])) { // Obsuga formularza.

	// Identyfikator jzyka ($lid) przechowywany w sesji.
        // Sprawdza istnienie identyfikatora watku.
	$tid = FALSE;
	if (isset($_POST['tid']) && is_numeric($_POST['tid']) ) {
		$tid = (int) $_POST['tid'];
		if ($tid <= 0) { 
			$tid = FALSE;
		}
	}

	// Jeli brak identyfikatora wtku, uytkownik musi wprowadzi temat.
	if (!$tid && empty($_POST['subject'])) {
		$subject = FALSE;
		echo '<p>Wprowad temat wiadomoci.</p>';
	} elseif (!$tid && !empty($_POST['subject'])) {
		$subject = htmlspecialchars(strip_tags($_POST['subject']));
	} else { // Temat zbdny.
		$subject = TRUE;
	}
	
	// Sprawdza tre.
	if (!empty($_POST['body'])) {
		$body = htmlentities($_POST['body']);
	} else {
		$body = FALSE;
		echo '<p>Wprowad tre wiadomoci.</p>';
	}
	
	if ($subject && $body) { // OK!
	
		// Wstawia wiadomo do bazy...
		
		if (!$tid) { // Tworzy nowy wtek.
			$q = "INSERT INTO threads (lang_id, user_id, subject) VALUES ({$_SESSION['lid']}, {$_SESSION['user_id']}, '" . mysqli_real_escape_string($dbc, $subject) . "')";
			$r = mysqli_query($dbc, $q);
			if (mysqli_affected_rows($dbc) == 1) {
				$tid = mysqli_insert_id($dbc);
			} else {
				echo '<p>Wiadomo nie zostaa wstawiona z powodu bdu systemu.</p>';
			}

		} 
		
		if ($tid) { // Wstawia do bazy.

			$q = "INSERT INTO posts (thread_id, user_id, message, posted_on) VALUES ($tid, {$_SESSION['user_id']}, '" . mysqli_real_escape_string($dbc, $body) . "', UTC_TIMESTAMP())";
			$r = mysqli_query($dbc, $q);
			if (mysqli_affected_rows($dbc) == 1) {
				echo '<p>Wiadomo zostaa umieszczona na forum.</p>';
			} else {
				echo '<p>Wiadomo nie zostaa wstawiona z powodu bdu systemu.</p>';
			}

		}
	
	} else { // Docza formularz.
		include ('post_form.php');
	}

} else { // Wywietla formularz.
	
	include ('post_form.php');

}

include ('includes/stopka.html');
?>
