<?php # Skrypt 9.2 - usun_uzytkownika.php

// Usuwa uytkownika.
// Jest uywany przez pokaz_uzytkownika.php.

$page_title = 'Usu uytkownika';
include ('includes/naglowek.html');

echo '<h1>Usu uytkownika</h1>';

// Sprawdza poprawno identyfikatora uytkownika, przekazanego za pomoc GET lub POST.

if ( (isset($_GET['id'])) && (is_numeric($_GET['id'])) ) { // Przekazany przez pokaz_uzytkownika.php
	$id = $_GET['id'];
} elseif ( (isset($_POST['id'])) && (is_numeric($_POST['id'])) ) { // Formularz wysany.
	$id = $_POST['id'];
} else { // Brak poprawnego identyfikatora, zakocz skrypt.
	echo '<p class="error">Bd dostpu do strony.</p>';
	include ('includes/stopka.html'); 
	exit();
}

require_once ('../mysqli_connect.php');

// Sprawd, czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	if ($_POST['sure'] == 'Yes') { // Usu rekord.

		// Utwrz zapytanie.
		$q = "DELETE FROM users WHERE user_id=$id LIMIT 1";		
		$r = @mysqli_query ($dbc, $q);
		if (mysqli_affected_rows($dbc) == 1) { // Jeli wykonane pomylnie.
		
			// Wywietl komunikat.
			echo '<p>Uytkownik zosta usunity.</p>';	
		
		} else { // Jeli zapytanie nie zostao wykonane poprawnie.
			echo '<p class="error">Uytkownik nie zosta usunity z powodu bdu systemu.</p>'; // Komunikat dla uytkownika.
			echo '<p>' . mysqli_error($dbc) . '<br />Zapytanie: ' . $q . '</p>'; // Komunikat uruchomieniowy.
		}
	
	} else { // Uytkownik nie potwierdzi usunicia.
		echo '<p>Uytkownik NIE zosta usunity.</p>';	
	}

} else { // Wywietl formularz.

	// Pobierz informacje o uytkowniku.
	$q = "SELECT CONCAT(last_name, ', ', first_name) FROM users WHERE user_id=$id";
	$r = @mysqli_query ($dbc, $q);
	
	if (mysqli_num_rows($r) == 1) { // Jeli identyfikator by poprawny, to wywietl formularz.

		// Pobierz informacje o uytkowniku.
		$row = mysqli_fetch_array ($r, MYSQLI_NUM);
		
		// Utwrz formularz.
		echo '<form action="usun_uzytkownika.php" method="post">
	<h3>Nazwisko: ' . $row[0] . '</h3>
	<p>Czy na pewno chcesz usun tego uytkownika?<br />
	<input type="radio" name="sure" value="Yes" /> Tak
	<input type="radio" name="sure" value="No" checked="checked" /> Nie</p>
	<p><input type="submit" name="submit" value="Wylij" /></p>
	<input type="hidden" name="submitted" value="TRUE" />
	<input type="hidden" name="id" value="' . $id . '" />
	</form>';
	
	} else { // Niepoprawny identyfikator.
		echo '<p class="error">Bd podczas dostpu do strony.</p>';
	}

} // Koniec gwnej instrukcji if..

mysqli_close($dbc);
		
include ('includes/stopka.html');
?>
