<?php # Skrypt 9.1 - pokaz_uzytkownikow.php #3

// Pobiera wszystkie rekordy z tabeli users.
// Nowa wersja zawierajca cza do stron edycji i usuwania.

$page_title = 'Zobacz zarejestrowanych uytkownikw';
include ('includes/naglowek.html');

echo '<h1>Zarejestrowani uytkownicy</h1>';

require_once ('../mysqli_connect.php');
		
// Utwrz zapytanie.
$q = "SELECT last_name, first_name, DATE_FORMAT(registration_date, '%M %d, %Y') AS dr, user_id FROM users ORDER BY registration_date ASC";		
$r = @mysqli_query ($dbc, $q);

// Okrel liczb zwrconych rekordw.
$num = mysqli_num_rows($r);

if ($num > 0) { // Jeeli zapytanie zostao wykonane poprawnie, poka rekordy.

	// Wywietl liczb uytkonikw.
	echo "<p>Obecnie zarejestrowanych jest $num uytkownikw.</p>\n";

	// Nagwek tabeli.
	echo '<table align="center" cellspacing="3" cellpadding="3" width="75%">
	<tr>
		<td align="left"><b>Edytuj</b></td>
		<td align="left"><b>Usu</b></td>
		<td align="left"><b>Nazwisko</b></td>
		<td align="left"><b>Imi</b></td>
		<td align="left"><b>Data rejestracji</b></td>
	</tr>
';
	
	// Pobierz i poka wszystkie rekordy.
	while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
		echo '<tr>
			<td align="left"><a href="edit_user.php?id=' . $row['user_id'] . '">Edytuj</a></td>
			<td align="left"><a href="delete_user.php?id=' . $row['user_id'] . '">Usu</a></td>
			<td align="left">' . $row['last_name'] . '</td>
			<td align="left">' . $row['first_name'] . '</td>
			<td align="left">' . $row['dr'] . '</td>
		</tr>
		';
	}

	echo '</table>';
	mysqli_free_result ($r);	

} else { // Jeli zapytanie nie zwrcio adnego rekordu.
	echo '<p class="error">Brak zarejestrowanych uytkownikw.</p>';
}

mysqli_close($dbc);

include ('includes/stopka.html');
?>
