<?php # Skrypt 8.3 - rejestracja.php

$page_title = 'Zarejestruj si';
include ('includes/naglowek.html');

// Sprawd, czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	$errors = array(); // Zainicjuj tablic bdw.
	
	// Sprawd imi.
	if (empty($_POST['first_name'])) {
		$errors[] = 'Zapomniae poda swoje imi!';
	} else {
		$fn = trim($_POST['first_name']);
	}
	
	// Sprawd nazwisko.
	if (empty($_POST['last_name'])) {
		$errors[] = 'Zapomniae poda swoje nazwisko!';
	} else {
		$ln = trim($_POST['last_name']);
	}
	
	// Sprawd adres e-mail.
	if (empty($_POST['email'])) {
		$errors[] = 'Zapomniae poda swj adres e-mail!';
	} else {
		$e = trim($_POST['email']);
	}
	
	// Sprawd, czy uytkownik wprowadzi haso i czy w obu polach jest ono takie samo.
	if (!empty($_POST['pass1'])) {
		if ($_POST['pass1'] != $_POST['pass2']) {
			$errors[] = 'Za drugim razem wpisae inne haso!';
		} else {
			$p = trim($_POST['pass1']);
		}
	} else {
		$errors[] = 'Zapomniae wprowadzi haso!';
	}
	
	if (empty($errors)) { // Jeli formularz poprawnie wypeniony.
	
		// Zarejestruj uytkownika w bazie danych.
		
		require_once ('../mysqli_connect.php'); // Pocz si z baz danych.
		
		// Utwrz zapytanie.
		$q = "INSERT INTO users (first_name, last_name, email, pass, registration_date) VALUES ('$fn', '$ln', '$e', SHA1('$p'), NOW() )";		
		$r = @mysqli_query ($dbc, $q); // Wykonaj zapytanie.
		if ($r) { // Jeli poprawnie wykonane.
		
			// Wywietl komunikat.
			echo '<h1>Dzikujemy!</h1>
		<p>Zostae zarejestrowany. W rozdziale 11. bdziesz mg si zalogowa!</p><p><br /></p>';	
		
		} else { // Jeli zapytanie nie zostao poprawnie wykonane.
			
			// Komunikat dla uytkownika.
			echo '<h1>Bd systemu</h1>
			<p class="error">Nie zostae zarejestrowany z powodu awarii naszego systemu.  Przepraszamy za kopot.</p>'; 
			
			// Komunikat uruchomieniowy.
			echo '<p>' . mysqli_error($dbc) . '<br /><br />Zapytanie: ' . $q . '</p>';
						
		} // Koniec instrukcji if ($r) .
		
		mysqli_close($dbc); // Zamknij poczenie z baz danych.
		
		// Docz stopk i zakocz dziaanie skryptu.
		include ('includes/stopka.html'); 
		exit();
		
	} else { // Raportuj bdy.
	
		echo '<h1>Bd!</h1>
		<p class="error">Wystpiy nastpujce bdy:<br />';
		foreach ($errors as $msg) { // Wywietl kady komunikat o bdzie.
			echo " - $msg<br />\n";
		}
		echo '</p><p>Sprbuj jeszcze raz.</p><p><br /></p>';
		
	} // Koniec instrukcji if (empty($errors)).

} // Koniec gwnej instrukcji warunkowej (wysania formularza).
?>
<h1>Zarejestruj si</h1>
<form action="rejestracja.php" method="post">
	<p>Imi: <input type="text" name="first_name" size="15" maxlength="20" value="<?php if (isset($_POST['first_name'])) echo $_POST['first_name']; ?>" /></p>
	<p>Nazwisko: <input type="text" name="last_name" size="15" maxlength="40" value="<?php if (isset($_POST['last_name'])) echo $_POST['last_name']; ?>" /></p>
	<p>Adres e-mail: <input type="text" name="email" size="20" maxlength="80" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>"  /> </p>
	<p>Haso: <input type="password" name="pass1" size="10" maxlength="20" /></p>
	<p>Potwierd haso: <input type="password" name="pass2" size="10" maxlength="20" /></p>
	<p><input type="submit" name="submit" value="Zarejestruj" /></p>
	<input type="hidden" name="submitted" value="TRUE" />
</form>
<?php
include ('includes/stopka.html');
?>
