<?php # Skrypt 3.9 - kalkulator.php #4

$page_title = 'Kalkulator sprzeday';
include ('includes/naglowek.html');

/* Funkcja wyliczajca cakowit warto sprzeday
i wywietlajca wyniki.  
Argument $tax jest opcjonalny (ma domyln warto). */
function calculate_total ($qty, $cost, $tax = 5) {

	$total = ($qty * $cost);
	$taxrate = ($tax / 100); // Zamienia 5% na .05.
	$total += ($total * $taxrate); // Uwzgldnia podatek.

	// Wywietla wyniki.
	echo '<p>Kupujesz ' . $qty . ' sztuk w cenie ' . number_format ($cost, 2) . ' z za kad. Po uwzgldnieniu podatku ' . $tax . '%, daje to cakowity koszt ' . number_format ($total, 2) . ' z.</p>';

} // Koniec funkcji.

// Sprawdza czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	// Podstawowa kontrola poprawnoci wprowadzonych danych.
	if ( is_numeric($_POST['quantity']) && is_numeric($_POST['price']) ) {
	
		// Wywietla nagwek.
		echo '<h1>czna warto sprzeday</h1>';

		// Wywouje funkcj przekazujc jej warto podatku lub nie.
		if (is_numeric($_POST['tax'])) {
			calculate_total ($_POST['quantity'], $_POST['price'], $_POST['tax']);
		} else {
			calculate_total ($_POST['quantity'], $_POST['price']);
		}
					
	} else { // Wprowadzono niepoprawne dane.
		echo '<h1>Bd!</h1>
		<p class="error">Wprowad poprawn liczb egzemplarzy, cen i podatek.</p>';
	}
	
} // End of main isset() IF.

// Leave the PHP section and create the HTML form:
?>
<h1>Widget Cost Calculator</h1>
<form action="calculator.php" method="post">
	<p>Quantity: <input type="text" name="quantity" size="5" maxlength="5" value="<?php if (isset($_POST['quantity'])) echo $_POST['quantity']; ?>" /></p>
	<p>Price: <input type="text" name="price" size="5" maxlength="10" value="<?php if (isset($_POST['price'])) echo $_POST['price']; ?>" /></p>
	<p>Tax (%): <input type="text" name="tax" size="5" maxlength="5" value="<?php if (isset($_POST['tax'])) echo $_POST['tax']; ?>" /> (optional)</p>
	<p><input type="submit" name="submit" value="Calculate!" /></p>
	<input type="hidden" name="submitted" value="TRUE" />
</form>
<?php // Include the footer:
include ('includes/footer.html');
?>
