<?php # Skrypt 17.9 - view_cart.php
// Ta strona wywietla zawarto koszyka.
// Pozwala rwnie na zmian zawartoci koszyka.

// Konfiguruje tytu strony i docza nagowek HTML.
$page_title = 'Zawarto koszyka';
include ('./includes/header.html');

// Sprawdza, czy formularz zosta przesany (w celu zaktualizowania koszyka).
if (isset($_POST['submitted'])) {

	// Zmienia ilo produktw.
	foreach ($_POST['qty'] as $k => $v) {

		// Tylko liczby cakowite!
		$pid = (int) $k;
		$qty = (int) $v;
		
		if ( $qty == 0 ) { // Usuwa.
			unset ($_SESSION['cart'][$pid]);
		} elseif ( $qty > 0 ) { // Zmienia ilo.
			$_SESSION['cart'][$pid]['quantity'] = $qty;
		}
		
	} // Koniec ptli foreach.
} // Koniec instrukcji if sprawdzajcej czy formularz zosta wysany.

// Wywietla koszyk, jeli nie jest pusty.
if (!empty($_SESSION['cart'])) {

	// Pobiera wszystkie informacje o odbitkach w koszyku.
	require_once ('../mysqli_connect.php');
	$q = "SELECT print_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS artist, print_name FROM artists, prints WHERE artists.artist_id = prints.artist_id AND prints.print_id IN (";
	foreach ($_SESSION['cart'] as $pid => $value) {
		$q .= $pid . ',';
	}
	$q = substr($q, 0, -1) . ') ORDER BY artists.last_name ASC';
	$r = mysqli_query ($dbc, $q);
	
	// Tworzy formularz i tabel.
	echo '<form action="view_cart.php" method="post">
<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
	<tr>
		<td align="left" width="30%"><b>Artysta</b></td>
		<td align="left" width="30%"><b>Nazwa odbitki</b></td>
		<td align="right" width="10%"><b>Cena</b></td>
		<td align="center" width="10%"><b>Ilo</b></td>
		<td align="right" width="10%"><b>Kwota</b></td>
	</tr>
';

	// Wywietla poszczeglne odbitki.
	$total = 0; // czna kwota zamwienia.
	while ($row = mysqli_fetch_array ($r, MYSQLI_ASSOC)) {
		
		// Oblicza sum i sumy czciowe.
		$subtotal = $_SESSION['cart'][$row['print_id']]['quantity'] * $_SESSION['cart'][$row['print_id']]['price'];
		$total += $subtotal;
		
		// Wywietla wiersz.
		echo "\t<tr>
		<td align=\"left\">{$row['artist']}</td>
		<td align=\"left\">{$row['print_name']}</td>
		<td align=\"right\">\${$_SESSION['cart'][$row['print_id']]['price']}</td>
		<td align=\"center\"><input type=\"text\" size=\"3\" name=\"qty[{$row['print_id']}]\" value=\"{$_SESSION['cart'][$row['print_id']]['quantity']}\" /></td>
		<td align=\"right\">$" . number_format ($subtotal, 2) . "</td>
	</tr>\n";
	
	} // Koniec ptli while.
	
	mysqli_close($dbc); // Zamyka poczenie z baz danych.

     // Wywietla stopk, koczy tabel i formularz.
	echo '<tr>
		<td colspan="4" align="right"><b>Suma:</b></td>
		<td align="right">$' . number_format ($total, 2) . '</td>
	</tr>
	</table>
	<div align="center"><input type="submit" name="submit" value="Aktualizuj koszyk" /></div>
	<input type="hidden" name="submitted" value="TRUE" />
	</form><p align="center">Wprowad warto 0, aby usun pozycj.
	<br /><br /><a href="checkout.php">Checkout</a></p>';

} else {
	echo '<p>Twj koszyk jest obecnie pusty.</p>';
}

include ('./includes/footer.html');
?>
