<?php # Skrypt 17.10 - checkout.php
// Ta strona wstawia informacje o zamwieniu do tabeli bazy danych.
// Strona ta byaby wywietlana po obcieniu rachunku klienta.
// Zakadamy, e proces fakturowania zakoczy si powodzeniem (otrzymalimy pienidze).

// Konifguruje tytu strony i docza nagwek HTML.
$page_title = 'Potwierdzenie zamwienia';
include ('includes/header.html');

// Zakadam, e klient jest zalogowany i e strona ma dostp do jego identyfikatora.
$customer = 1; // Tymczasowe.

// Zakadam, e strona otrzymaa czn kwot zamwienia.
$total = 178.93; // Tymczasowe.

require_once ('../mysqli_connect.php'); // czy si z baz danych.

// Wycza automatyczne zatwierdzanie.
mysqli_autocommit($dbc, FALSE);

// Dodaje zamwienie do tabeli orders.
$q = "INSERT INTO orders (customer_id, total) VALUES ($customer, $total)";
$r = mysqli_query($dbc, $q);
if (mysqli_affected_rows($dbc) == 1) {

	// Potrzebuje identyfikatora zamwienia.
	$oid = mysqli_insert_id($dbc);
	
	// Wstawia zawarto zamwienia do bazy danych.
	
	// Przygotowuje zapytanie.
	$q = "INSERT INTO order_contents (order_id, print_id, quantity, price) VALUES (?, ?, ?, ?)";
	$stmt = mysqli_prepare($dbc, $q);
	mysqli_stmt_bind_param($stmt, 'iiid', $oid, $pid, $qty, $price);
	
	// Wykonuje kolejne zapytania, zliczajc zmodyfikowane rekordy.
	$affected = 0;
	foreach ($_SESSION['cart'] as $pid => $item) {
		$qty = $item['quantity'];
		$price = $item['price'];
		mysqli_stmt_execute($stmt);
		$affected += mysqli_stmt_affected_rows($stmt);
	}

	// Zamyka polecenie przygotowane.
	mysqli_stmt_close($stmt);

	// Raportuje wynik operacji.
	if ($affected == count($_SESSION['cart'])) { // Hoho!
	
		// Zatwierdza transakcj.
		mysqli_commit($dbc);
		
		// Usuwa zawarto koszyka.
		//unset($_SESSION['cart']);
		
		// Komunikat dla klienta.
		echo '<p>Dzikujemy za zoenie zamwienia. Zostaniesz poinformowany o wysyce towaru.</p>';
		
		// Tu mona wysa wiadomo e-mail itd.
	
	} else { // Odwouje transakcj i raportuje problem.
	
		mysqli_rollback($dbc);
		
		echo '<p>Nie udao si przetworzy zamwienia ze wzgldu na bd systemu. Nasz pracownik skontaktuje si z Tob w celu rozwizania problemu. Przepraszamy za niedogodno.</p>';
           // Tu naley wysa informacje o zamwieniu do administratora.
		
	}

} else { // Odwouje transakcj i raportuje problem.

	mysqli_rollback($dbc);

	echo ''<p>Nie udao si przetworzy zamwienia ze wzgldu na bd systemu. Nasz pracownik skontaktuje si z Tob w celu rozwizania problemu. Przepraszamy za niedogodno.</p>';
           // Tu naley wysa informacje o zamwieniu do administratora.
	
}

mysqli_close($dbc);

include ('./includes/footer.html');
?>
