<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
	<meta http-equiv="content-type" content="text/html; charset=iso-8859-2" />
	<title>Dodaj odbitk</title>
</head>
<body>
<?php # Skrypt 17.1 - add_print.php
// Ta strona umoliwia administratorowi dodanie odbitki (produktu).

require_once ('../../mysqli_connect.php');

if (isset($_POST['submitted'])) { // Obsuguje formularz.
	
	// Sprawdza poprawno wprowadzonych danych.
	$errors = array();

	// Sprawdza nazw odbitki.
	if (!empty($_POST['print_name'])) {
		$pn = trim($_POST['print_name']);
	} else {
		$errors[] = 'Podaj nazw odbitki!';
	}
	
	// Sprawdza obrazek.
	if (is_uploaded_file ($_FILES['image']['tmp_name'])) {
	
		// Tworzy tymczasow nazw pliku.
		$temp = '../../uploads/' . md5($_FILES['image']['name']);
	
		// Przenosi plik.
		if (move_uploaded_file($_FILES['image']['tmp_name'], $temp)) {
	
			echo '<p>Plik zosta zaadowany na serwer!</p>';
			
			// Zmienna $i bdzie przechowywa nazw obrazka.
			$i = $_FILES['image']['name'];
	
		} else { // Nie udao si przenie pliku.
			$errors[] = 'Nie udao si przenie pliku.';
			$temp = $_FILES['image']['tmp_name'];
		}

	} else { // Plik nie zosta zaadowany.
		$errors[] = 'Nie zaadowano adnego pliku.';
		$temp = NULL;
	}
	
	// Sprawdza rozmiar (nie jest wymagany).
	$s = (!empty($_POST['size'])) ? trim($_POST['size']) : NULL;
	
	// Sprawdza cen.
	if (is_numeric($_POST['price'])) {
		$p = (float) $_POST['price'];
	} else {
		$errors[] = 'Podaj cen odbitki!';
	}
	
	// Sprawdza opis (nie jest wymagany).
	$d = (!empty($_POST['description'])) ? trim($_POST['description']) : NULL;
	
	// Sprawdza poprawno informacji o artycie.
	if (isset($_POST['artist']) && ($_POST['artist'] == 'new') ) {
		// Jeli jest to nowy artysta, dodaje go do bazy danych.
		
		// Sprawdza pierwsze i drugie imi (oba nie s wymagane).
		$fn = (!empty($_POST['first_name'])) ? trim($_POST['first_name']) : NULL;
		$mn = (!empty($_POST['middle_name'])) ? trim($_POST['middle_name']) : NULL;

		// Sprawdza nazwisko.
		if (!empty($_POST['last_name'])) {
			
			$ln = trim($_POST['last_name']);
			
			// Umieszcza artyst w bazie danych.
			$q = 'INSERT INTO artists (first_name, middle_name, last_name) VALUES (?, ?, ?)';
			$stmt = mysqli_prepare($dbc, $q);
			mysqli_stmt_bind_param($stmt, 'sss', $fn, $mn, $ln);
			mysqli_stmt_execute($stmt);
			
			// Sprawdza wynik zapytania.
			if (mysqli_stmt_affected_rows($stmt) == 1) {
				echo '<p>Artysta zosta umieszczony w bazie.</p>';
				$a = mysqli_stmt_insert_id($stmt); // Get the artist ID.
			} else { // Bd!
				$errors[] = 'Nie udao si doda nowego artysty!';
			}
			
			// Zamyka polecenie przygotowane.
			mysqli_stmt_close($stmt);
			
		} else { // Brak nazwiska.
			$errors[] = 'Podaj nazwisko artysty!';
		}
		
	} elseif ( isset($_POST['artist']) && ($_POST['artist'] == 'existing') && ($_POST['existing'] > 0) ) { // Istniejcy artysta.
		$a = (int) $_POST['existing'];
	} else { // Nie wybrano artysty.
		$errors[] = 'Podaj informacje o artycie lub wybierz go z listy!';
	}
	
	if (empty($errors)) { // Jeli wszystko OK.
	
		// Dodajemy odbitk do bazy danych.
		$q = 'INSERT INTO prints (artist_id, print_name, price, size, description, image_name) VALUES (?, ?, ?, ?, ?, ?)';
		$stmt = mysqli_prepare($dbc, $q);
		mysqli_stmt_bind_param($stmt, 'isdsss', $a, $pn, $p, $s, $d, $i);
		mysqli_stmt_execute($stmt);
		
		// Sprawdza wynik zapytania.
		if (mysqli_stmt_affected_rows($stmt) == 1) {
		
			// Wywietla komunikat.
			echo '<p>Odbitka zostaa dodana do bazy danych.</p>';
			
			// Zmienia nazw obrazka.
			$id = mysqli_stmt_insert_id($stmt); // Pobiera identyfikator odbitki.
			rename ($temp, "../../uploads/$id");
			
			// Oprnia tablic $_POST.
			$_POST = array();
			
		} else { // Bd!
			echo '<p style="font-weight: bold; color: #C00">Nie udao si przetworzy danych ze wzgldu na bd systemu.</p>'; 
		}
		
		mysqli_stmt_close($stmt);
		
	} // Koniec instrukcji if $errors.
	
	// Usuwa zaadowany plik, jeli jeszcze istnieje.
	if ( isset($temp) && file_exists ($temp) && is_file($temp) ) {
		unlink ($temp);
	}
	
} // Koniec instrukcji warunkowej zwizanej z obsug formularza.

// Sprawdza istnienie komunikatw o bdach i wywietla je.
if ( !empty($errors) && is_array($errors) ) {
	echo '<h1>Bd!</h1>
	<p style="font-weight: bold; color: #C00">Wystpiy nastpujce bdy:<br />';
	foreach ($errors as $msg) {
		echo " - $msg<br />\n";
	}
	echo 'Wybierz obrazek i sprbuj jeszcze raz.</p>';
}

// Wywietla formularz.
?>
<h1>Dodaj odbitk</h1>
<form enctype="multipart/form-data" action="add_print.php" method="post">

	<input type="hidden" name="MAX_FILE_SIZE" value="524288" />
	
	<fieldset><legend>Wypenij formularz, aby doda odbitk do katalogu:</legend>
	
	<p><b>Nazwa odbitki:</b> <input type="text" name="print_name" size="30" maxlength="60" value="<?php if (isset($_POST['print_name'])) echo htmlspecialchars($_POST['print_name']); ?>" /></p>
	
	<p><b>Obrazek:</b> <input type="file" name="image" /></p>
	
	<div><b>Artysta:</b> 
	<p><input type="radio" name="artist" value="existing" <?php if (isset($_POST['artist']) && ($_POST['artist'] == 'existing') ) echo ' checked="checked"'; ?>/> Istniejcy =>
	<select name="existing"><option>Wybierz artyst</option>
	<?php // Pobiera wszystkich artystw i dodaje ich do menu rozwijanego.
	$q = "SELECT artist_id, CONCAT_WS(' ', first_name, middle_name, last_name) FROM artists ORDER BY last_name, first_name ASC";		
	$r = mysqli_query ($dbc, $q);
	if (mysqli_num_rows($r) > 0) {
		while ($row = mysqli_fetch_array ($r, MYSQLI_NUM)) {
			echo "<option value=\"$row[0]\"";
			// Sprawdza czy zapamita wybran pozycj menu.
			if (isset($_POST['existing']) && ($_POST['existing'] == $row[0]) ) echo ' selected="selected"';
			echo ">$row[1]</option>\n";
		}
	} else {
		echo '<option>Dodaj nowego artyst.</option>';
	}
	mysqli_close($dbc); // Zamyka poczenie z baz danych.
	?>
	</select></p>
	
	<p><input type="radio" name="artist" value="new" <?php if (isset($_POST['artist']) && ($_POST['artist'] == 'new') ) echo ' checked="checked"'; ?>/> Nowy =>
	Imi: <input type="text" name="first_name" size="10" maxlength="20" value="<?php if (isset($_POST['first_name'])) echo $_POST['first_name']; ?>" />
	Drugie imi: <input type="text" name="middle_name" size="10" maxlength="20" value="<?php if (isset($_POST['middle_name'])) echo $_POST['middle_name']; ?>" />
	Nazwisko: <input type="text" name="last_name" size="10" maxlength="40" value="<?php if (isset($_POST['last_name'])) echo $_POST['last_name']; ?>" /></p>
	</div>
	
	<p><b>Cena:</b> <input type="text" name="price" size="10" maxlength="10" value="<?php if (isset($_POST['price'])) echo $_POST['price']; ?>" /> <small>Nie naley wpisywa przecinkw ani znaku dolara.</small></p>
	
	<p><b>Rozmiar:</b> <input type="text" name="size" size="30" maxlength="60" value="<?php if (isset($_POST['size'])) echo htmlspecialchars($_POST['size']); ?>" /> (opcjonalny)</p>
	
	<p><b>Opis:</b> <textarea name="description" cols="40" rows="5"><?php if (isset($_POST['description'])) echo $_POST['description']; ?></textarea> (opcjonalny)</p>
	
	</fieldset>
		
	<div align="center"><input type="submit" name="submit" value="Wylij" /></div>
	<input type="hidden" name="submitted" value="TRUE" />

</form>

</body>
</html>
