<?php # Skrypt 16.6 - register.php
// Strona rejestracji uytkownika w witrynie.

require_once ('includes/config.inc.php');
$page_title = 'Rejestracja';
include ('includes/header.html');

if (isset($_POST['submitted'])) { // Obsuga formularza.

	require_once (MYSQL);
	
	// Usuwa zbdne odstpy z wszystkich danych wejciowych.
	$trimmed = array_map('trim', $_POST);
	
	// Zakada, e dane s niepoprawne.
	$fn = $ln = $e = $p = FALSE;
	
	// Sprawdza imi.
	if (preg_match ('/^[A-Z \'.-]{2,20}$/i', $trimmed['first_name'])) {
		$fn = mysqli_real_escape_string ($dbc, $trimmed['first_name']);
	} else {
		echo '<p class="error">Prosz poda imi!</p>';
	}
	
	// Sprawdza nazwisko.
	if (preg_match ('/^[A-Z \'.-]{2,40}$/i', $trimmed['last_name'])) {
		$ln = mysqli_real_escape_string ($dbc, $trimmed['last_name']);
	} else {
		echo '<p class="error">Prosz poda nazwisko!</p>';
	}
	
	// Sprawdza adres e-mail.
	if (preg_match ('/^[\w.-]+@[\w.-]+\.[A-Za-z]{2,6}$/', $trimmed['email'])) {
		$e = mysqli_real_escape_string ($dbc, $trimmed['email']);
	} else {
		echo '<p class="error">Prosz wprowadzi poprawny adres e-mail!</p>';
	}

	// Check for a password and match against the confirmed password:
	if (preg_match ('/^\w{4,20}$/', $trimmed['password1']) ) {
		if ($trimmed['password1'] == $trimmed['password2']) {
			$p = mysqli_real_escape_string ($dbc, $trimmed['password1']);
		} else {
			echo '<p class="error">Za drugim razem wpisae inne haso!</p>';
		}
	} else {
		echo '<p class="error">Prosz poda prawidowe haso!</p>';
	}
	
	if ($fn && $ln && $e && $p) { // Jeli wszystkie dane poprawne...

		// Sprawdza adres e-mail w bazie danych.
		$q = "SELECT user_id FROM users WHERE email='$e'";
		$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Bd MySQL: " . mysqli_error($dbc));
		
		if (mysqli_num_rows($r) == 0) { // Available.
		
			// Tworzy kod aktywacji.
			$a = md5(uniqid(rand(), true));
		
			// Dodaje uytkownika do bazy.
			$q = "INSERT INTO users (email, pass, first_name, last_name, active, registration_date) VALUES ('$e', SHA1('$p'), '$fn', '$ln', '$a', NOW() )";
			$r = mysqli_query ($dbc, $q) or trigger_error("Zapytanie: $q\n<br />Bd MySQL: " . mysqli_error($dbc));

			if (mysqli_affected_rows($dbc) == 1) { // Zapytanie wykonane poprawnie.
			
				// Wysya e-mail.
				$body = "Dzikujemy za zarejestrowanie si w naszej witrynie.Aby uaktywni swoje konto, kliknij ponisze cze:\n\n";
				$body .= BASE_URL . 'activate.php?x=' . urlencode($e) . "&y=$a";
				mail($trimmed['email'], 'Potwierdzenie rejestracji', $body, 'From: admin@sitename.com');
				
				// Finish the page:
				echo '<h3>Dzikujemy za zarejestrowanie si! Pod Twj adres zostaa wysana wiadomo e-mail z potwierdzeniem rejestracji. Kliknij cze w tej wiadomoci, aby uaktywni swoje  konto.</h3>';
				include ('includes/footer.html'); // Docza stopk HTML.
				exit(); // Koczy dziaanie strony.
				
			} else { // Zapytanie nie zostao wykonane poprawnie.
				echo '<p class="error">Konto nie zostao zarejestrowane ze wzgldu na bd systemu. Przepraszamy za   niedogodno.</p>';
			}
			
		} else { // Adres e-mail zosta ju zarejestrowany.
			echo '<p class="error">Ten adres e-mail jest ju zarejestrowany. Jeli zapomniae hasa, kliknij odpowiednie cze, a przelemy Ci haso.</p>';
		}
		
	} else { // Jeli weryfikacja hasa nie powioda si.
		echo '<p class="error">Prosz ponownie wprowadzi hasa i sprbowa jeszcze raz.</p>';
	}

	mysqli_close($dbc);

} // Koniec gwnej instrukcji warunkowej.
?>
	
<h1>Rejestracja</h1>
<form action="register.php" method="post">
	<fieldset>
	
	<p><b>Imi:</b> <input type="text" name="first_name" size="20" maxlength="20" value="<?php if (isset($trimmed['first_name'])) echo $trimmed['first_name']; ?>" /></p>
	
	<p><b>Nazwisko:</b> <input type="text" name="last_name" size="20" maxlength="40" value="<?php if (isset($trimmed['last_name'])) echo $trimmed['last_name']; ?>" /></p>
	
	<p><b>Adres e-mail:</b> <input type="text" name="email" size="30" maxlength="80" value="<?php if (isset($trimmed['email'])) echo $trimmed['email']; ?>" /> </p>
		
	<p><b>Haso:</b> <input type="password" name="password1" size="20" maxlength="20" /> <small>Haso powinno zawiera od 4 do 20 znakw (tylko litery, cyfry i znak podkrelenia).</small></p>
	
	<p><b>Potwierdzenie hasa:</b> <input type="password" name="password2" size="20" maxlength="20" /></p>
	</fieldset>
	
	<div align="center"><input type="submit" name="submit" value="Rejestracja" /></div>
	<input type="hidden" name="submitted" value="TRUE" />

</form>

<?php // Docza stopk HTML.
include ('includes/footer.html');
?>
