<?php # Skrypt 15.5 - read.php
// Wywietla wszystkie wiadomoci wtku.
include ('includes/naglowek.html');


// Sprawdza identyfikator wtku.
$tid = FALSE;
if (isset($_GET['tid']) && is_numeric($_GET['tid'])) {

	$tid = (int) $_GET['tid'];

	if ($tid > 0) { // Sprawdza w bazie danych.
	
		// Przeksztaca dat i czas jeli uytkownik jest zalogowany.
		if (isset($_SESSION['user_tz'])) {
			$posted = "CONVERT_TZ(p.posted_on, 'UTC', '{$_SESSION['user_tz']}')";
		} else {
			$posted = 'p.posted_on';
		}

		// Wykonuje zapytanie.
		$q = "SELECT t.subject, p.message, username, DATE_FORMAT($posted, '%e-%b-%y %l:%i %p') AS posted FROM threads AS t LEFT JOIN posts AS p USING (thread_id) INNER JOIN users AS u ON p.user_id = u.user_id WHERE t.thread_id = $tid ORDER BY p.posted_on ASC";
		$r = mysqli_query($dbc, $q);
		if (!(mysqli_num_rows($r) > 0)) {
			$tid = FALSE; // Bdny identyfikator wtku!
		}
		
	} // Koniec instrukcji warunkowej ($tid > 0).

} // Koniec instrukcji warunkowej isset($_GET['tid']).

if ($tid) { // Pobiera wiadomoci wtku.

  $printed = FALSE; // Znacznik.

  // Pobiera kady rekord.

	while ($messages = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
	
		// Temat wywietla tylko raz!
		if (!$printed) {
			echo "<h2>{$messages['subject']}</h2>\n";
			$printed = TRUE;
		}
		
		// Wywietla wiadomo.
		echo "<p>{$messages['username']} ({$messages['posted']})<br />{$messages['message']}</p><br />\n";
	
	} // Koniec ptli while.

        // Wywietla formularz umoliwiajcy wstawienie nowej wiadomoci.
	include ('post_form.php');
	
} else { // Bdny identyfikator wtku!
	echo '<p>Bd podczas dostpu do strony.</p>';
}

include ('includes/stopka.html');
?>
