<?php # Skrypt 9.5 - pokaz_uzytkownikow.php #5

// Pobiera wszystkie rekordy z tabeli users.
// W tej wersji umoliwia sortowanie rekordw wedug rnych kolumn.

$page_title = 'Zobacz zarejestrowanych uytkownikw';
include ('includes/naglowek.html');
echo '<h1>Zarejestrowani uytkownicy</h1>';

require_once ('../mysqli_connect.php');

// Liczba rekordw na stronie.
$display = 10;

// Ustal liczb stron...

if (isset($_GET['p']) && is_numeric($_GET['p'])) { // Ju jest ustalona.
	$pages = $_GET['p'];
} else { // Dopiero naley j ustali.

 	// Liczba rekordw.
	$q = "SELECT COUNT(user_id) FROM users";
	$r = @mysqli_query ($dbc, $q);
	$row = @mysqli_fetch_array ($r, MYSQLI_NUM);
	$records = $row[0];

	// Oblicz liczb stron...
	if ($records > $display) { // Wicej ni 1 strona.
		$pages = ceil ($records/$display);
	} else {
		$pages = 1;
	}
} // Koniec instrukcji warunkowej zwizanej ze zmienn p.

// Okrel rekord od ktrego naley rozpocz wywietlanie...
if (isset($_GET['s']) && is_numeric($_GET['s'])) {
	$start = $_GET['s'];
} else {
	$start = 0;
}

// Okrel sposb sortowania...
// Domylnie wedug daty rejestracji.
$sort = (isset($_GET['sort'])) ? $_GET['sort'] : 'rd';

// Wybr sposobu sortowania.:
switch ($sort) {
	case 'ln':
		$order_by = 'last_name ASC';
		break;
	case 'fn':
		$order_by = 'first_name ASC';
		break;
	case 'rd':
		$order_by = 'registration_date ASC';
		break;
	default:
		$order_by = 'registration_date ASC';
		$sort = 'rd';
		break;
}
	
// Utwrz zapytanie.
$q = "SELECT last_name, first_name, DATE_FORMAT(registration_date, '%d %M %Y') AS dr, user_id FROM users ORDER BY $order_by LIMIT $start, $display";		
$r = @mysqli_query ($dbc, $q); // Wykonaj zapytanie.

// Nagwek tabeli.
echo '<table align="center" cellspacing="0" cellpadding="5" width="75%">
<tr>
	<td align="left"><b>Edytuj</b></td>
	<td align="left"><b>Usu</b></td>
	<td align="left"><b><a href="pokaz_uzytkownikow.php?sort=ln">Nazwisko</a></b></td>
	<td align="left"><b><a href="pokaz_uzytkownikow.php?sort=fn">Imi</a></b></td>
	<td align="left"><b><a href="pokaz_uzytkownikow.php?sort=rd">Data rejestracji</a></b></td>
</tr>
';

// Pobierz i poka wszystkie rekordy.
$bg = '#eeeeee'; 
while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
	$bg = ($bg=='#eeeeee' ? '#ffffff' : '#eeeeee');
		echo '<tr bgcolor="' . $bg . '">
		<td align="left"><a href="edytuj_uzytkownika.php?id=' . $row['user_id'] . '">Edytuj</a></td>
		<td align="left"><a href="usun_uzytkownika.php?id=' . $row['user_id'] . '">Usu</a></td>
		<td align="left">' . $row['last_name'] . '</td>
		<td align="left">' . $row['first_name'] . '</td>
		<td align="left">' . $row['dr'] . '</td>
	</tr>
	';
} // Koniec ptli while.

echo '</table>';
mysqli_free_result ($r);
mysqli_close($dbc);

// Tworzy cza do pozostaych stron, jeli to konieczne.
if ($pages > 1) {
	
	echo '<br /><p>';
	$current_page = ($start/$display) + 1;
	
	// Jeli nie jest to pierwsza strona, tworzy cze Poprzednia.
	if ($current_page != 1) {
		echo '<a href="pokaz_uzytkownikow.php?s=' . ($start - $display) . '&p=' . $pages . '&sort=' . $sort . '">Poprzednia</a> ';
	}
	
	// Tworzy cza stron oznaczone numerami.
	for ($i = 1; $i <= $pages; $i++) {
		if ($i != $current_page) {
			echo '<a href="pokaz_uzytkownikow.php?s=' . (($display * ($i - 1))) . '&p=' . $pages . '&sort=' . $sort . '">' . $i . '</a> ';
		} else {
			echo $i . ' ';
		}
	} // Koniec ptli for.
	
	// Jeli nie jest to ostatnia strona, tworzy cze Nastpna.
	if ($current_page != $pages) {
		echo '<a href="pokaz_uzytkownikow.php?s=' . ($start + $display) . '&p=' . $pages . '&sort=' . $sort . '">Nastpna</a>';
	}
	
	echo '</p>'; // Zamyka akapit.
	
} // Koniec sekcji czy.
	
include ('includes/stopka.html');
?>
