<?php # Skrypt 3.10 - kalkulator.php #5

$page_title = 'Kalkulator sprzeday';
include ('includes/naglowek.html');

/* Funkcja wyliczajca cakowit warto sprzeday
i zwracajca wynik.  
Argument $tax jest opcjonalny (ma domyln warto). */
function calculate_total ($qty, $cost, $tax = 5) {

	$total = ($qty * $cost);
	$taxrate = ($tax / 100); // Zamienia 5% na .05.
	$total += ($total * $taxrate); // Uwzgldnia podatek.
	
	return number_format($total, 2);

} // Koniec funkcji.

// Sprawdza czy formularz zosta wysany.
if (isset($_POST['submitted'])) {

	// Podstawowa kontrola poprawnoci wprowadzonych danych.
	if ( is_numeric($_POST['quantity']) && is_numeric($_POST['price']) ) {
	
		// Wywietla nagwek.
		echo '<h1>czna warto sprzeday</h1>';

		// Wywouje funkcj przekazujc jej warto podatku lub nie.
		if (is_numeric($_POST['tax'])) {
			$sum = calculate_total ($_POST['quantity'], $_POST['price'], $_POST['tax']);
		} else {
			$sum = calculate_total ($_POST['quantity'], $_POST['price']);
		}

		// Wywietla wyniki.
		echo '<p>Kupujesz ' . $_POST['quantity'] . ' sztuk w cenie ' . number_format ($_POST['price'], 2) . ' z za kad. Po uwzgldnieniu podatku daje to cakowity koszt ' . $sum . ' z.</p>';
					
	} else { // Wprowadzono niepoprawne dane.
		echo '<h1>Bd!</h1>
		<p class="error">Wprowad poprawn liczb egzemplarzy, cen i podatek.</p>';
	}
	
} // Koniec wyraenia isset() IF.

// Koniec sekcji PHP i pocztek formularza HTML:
?>
<h1>Kalkulator sprzeday</h1>
<form action="kalkulator.php" method="post">
	<p>Liczba egzemplarzy: <input type="text" name="quantity" size="5" maxlength="5" value="<?php if (isset($_POST['quantity'])) echo $_POST['quantity']; ?>" /></p>
	<p>Cena: <input type="text" name="price" size="5" maxlength="10" value="<?php if (isset($_POST['price'])) echo $_POST['price']; ?>" /></p>
	<p>Podatek (%): <input type="text" name="tax" size="5" maxlength="5" value="<?php if (isset($_POST['tax'])) echo $_POST['tax']; ?>" /> (opcjonalny)</p>
	<p><input type="submit" name="submit" value="Oblicz!" /></p>
	<input type="hidden" name="submitted" value="TRUE" />
</form>
<?php // Docza stopk.
include ('includes/stopka.html');
?>
